program CnvrtHlp;

{  This program will take a text file of and convert it to a help file  }
{  a return will be included where ever the next line starts with a '.' }
{  or a space.  Lines beginning with '{' will be ignored.  When the     }
{  program detects a blank line, a new help screen will be started.     }
{  The text file MUST have a blank line at the end for the program to   }
{  terminate successfully. If you are using the option to place a # at  }
{  the end of a help screen, to place the screen number in the lower    }
{  right hand corner of the screen, be sure to end the screen with a    }
{  period, and be sure there are as many spaces between the period and  }
{  the '#' to hold your entire reference mark (Max. 15).  Also, this    }
{  program will not work correctly if the '#' is on a line by itself,   }
{  unless it is preceeded by NO spaces. }

type
  TextRec = record
              NextRec : longint;
              case byte of
                0 : (Text : string [123]);
                1 : (Header : array [0 .. 30] of longint);
                end;

var
  OldHelpFile : text;
  OldHelpStr  : String;
  NewHelpFile : file of TextRec;
  Head, Help  : TextRec;
  OldHelpName,
  NewHelpName : string [63];
  HelpStr     : string;
  NewRec,
  HeaderRec,
  PrevRec     : word;
  HelpNum     : byte;

begin
  write ('Enter the name of the old help file: ');
  readln (OldHelpName);
  write ('Enter the name of the new help file: ');
  readln (NewHelpName);
  assign (OldHelpFile, OldHelpName);
  assign (NewHelpFile, NewHelpName);
  reset (OldHelpFile);
  rewrite (NewHelpFile);
  HelpNum := 1;
  HeaderRec := 0;
  HelpStr := '';
  PrevRec := 0;
  fillchar (Head, sizeof (Head), 0);
  write (NewHelpFile, Head);
  while (not EOF (OldHelpFile)) do begin
    Readln (OldHelpFile, OldHelpStr);
    if OldHelpStr > ''
      then begin
        if OldHelpStr [1] <> '{'
          then begin
            if (HelpStr <> '') and
               ((OldHelpStr [1] = ' ') or (OldHelpStr [1] = '.'))
              then begin
                HelpStr := HelpStr + #13;
                if OldHelpStr [1] = '.'
                  then delete (OldHelpStr, 1, 1);
                end;
            while (length (OldHelpStr) > 0) and
                  (OldHelpStr [length (OldHelpStr)] = ' ') do
              delete (OldHelpStr, length (OldHelpStr), 1);
            if OldHelpStr [length (oldHelpStr)] = '.'
              then OldHelpStr := OldHelpStr + '  '
              else OldHelpStr := OldHelpStr + ' ';
            HelpStr := HelpStr + OldHelpStr;
            while length (HelpStr) > 123 do begin
              NewRec := filesize (NewHelpFile);
              if PrevRec = 0
                then Head.Header [HelpNum] := NewRec
                else begin
                  Help.NextRec := NewRec;
                  Seek (NewHelpFile, PrevRec);
                  write (NewHelpFile, Help);
                  end;
              Help.Text := copy (HelpStr, 1, 123);
              Help.NextRec := 0;
              PrevRec := NewRec;
              seek (NewHelpFile, NewRec);
              write (NewHelpFile, Help);
              delete (HelpStr, 1, 123);
              end;                          { while length (HelpStr ..  }
            end;                            { if OldHelpStr [1] ..      }
        end                                 { if OldHelpStr >           }
      else begin
        if (HelpStr > '  ') or (Length (HelpStr) > 2)
          then begin
            NewRec := filesize (NewHelpFile);
            if PrevRec = 0
              then Head.Header [HelpNum] := NewRec
              else begin
                Help.NextRec := NewRec;
                Seek (NewHelpFile, PrevRec);
                write (NewHelpFile, Help);
                end;
            fillchar (Help, sizeof (Help), 0);
            Help.Text := HelpStr;
            PrevRec := NewRec;
            seek (NewHelpFile, NewRec);
            write (NewHelpFile, Help);
            write ('.');
            end;                            { if HelpStr > '  '     ..  }
        HelpStr := '';
        fillchar (Help, sizeof (Help), 0);
        inc (HelpNum);
        if (HelpNum > 30) and not EOF (OldHelpFile)
          then begin
            PrevRec := HeaderRec;
            HeaderRec := filesize (NewHelpFile);
            Head.NextRec := HeaderRec;
            seek (NewHelpFile, PrevRec);
            write (NewHelpFile, Head);
            write ('*');
            fillchar (Head, sizeof (Head), 0);
            seek (NewHelpFile, HeaderRec);
            write (NewHelpFile, Head);
            HelpNum := 0;
            end;
        PrevRec := 0;
        end;
    end;
  seek (newHelpFile, HeaderRec);
  write (NewHelpFile, Head);
  writeln ('*');
  close (OldHelpFile);
  close (NewHelpFile);
  end.

