Program field_3_demonstration;  { FLD3DEMO.PAS }

{ This program was written by Frank Wood to demonstrate the use of the unit
  FIELD3.PAS for controlled data entry followed by unrestricted data editing. }

Uses Crt,Dos,field3;

Type linestring  = String[80];                            { Utility string }
     namestring  = String[16];                            { Item names }
     item        = 1..28;                                 { Item numbers }
     fldlabtype  = Array[item] Of namestring;             { Field labels }
     direction   = (up,down,left,right);                  { Edit directions }
     nextfldtype = Array[item,direction] Of Byte;         { Next fields }
     columnnums  = 1..20;                                 { Column numbers }
     columninfo  = (lblcol,width,fldcol);                 { Column info }
     coldatatype = Array[columnnums,columninfo] Of Byte;  { Column data }

     compmwtype  = Array[item] Of Real;                   { Mole weights }

Const maxitemnum = 28;         { Maximum item number }

Var fldnum: Byte;              { Field number }
    maxfld: Byte;              { Maximum field number }
    fldlength: Byte;           { Field length }
    decpla: Byte;              { Decimal places }
    returnkey: Byte;           { Code for key that terminates field entry }
    titlerow: Byte;            { Title row }
    headrow: Byte;             { Heading row }
    outputrow: Byte;           { First output row }
    fldrow: Byte;              { Field row }
    freerows: Byte;            { Number of free rows }
    rowcount: Byte;            { Row count }
    itemnumber: Byte;          { Item number}
    compnumber: Byte;          { Component number }
    maxcompnum: Byte;          { Maximum component number }
    maxrow: Byte;              { Maximum number of rows }
    col: Byte;                 { Column number }
    row: Byte;                 { Row number }
    maxcol: Byte;              { Maximum column number }
    nextfld: nextfldtype;      { Array of next field numbers }
    coldata: coldatatype;      { Label location, width, field location }
    fldlabel: fldlabtype;      { Array of item labels }

    compmw: compmwtype;        { Array of component molecular weights }
    totalmassflow: Real;       { Total mass flow in pounds per hour }
    totalmoleflow: Real;       { Total molar flow in pound moles per hour }
    moleweight: Real;          { Molecular weight }

    compmassflow: Array[item] Of Real;  { Array of component mass flows }
    compmoleflow: Array[item] Of Real;  { Array of component molar flows }

    text: linestring;          { Output text }

{ The following procedure determines the minimum width for each input column
and then selects the location of the field labels and input fields in each
input column on this basis. }

Procedure colposinit(Var coldata:coldatatype;
                     maxfld,maxrow,maxcol,fldlength:Byte;
                     fldlabel:fldlabtype);

Var col,row,top,btm,labwidth,minwidth,gap: Byte;

Begin
  For col:=1 To maxcol Do coldata[col,width]:=0;
  col:=1;
  top:=1;
  btm:=top+maxrow-1;
  {determine the label width for each input column}
  Repeat
    Begin
      For row:= top To btm Do
        Begin
          labwidth:=length(fldlabel[row]);
          If labwidth > coldata[col,width] Then
            coldata[col,width]:=labwidth
        End;
      If btm <> maxfld Then
        Begin
          top:=btm+1;
          btm:=top+maxrow-1;
          If btm > maxfld Then btm:=maxfld
        End;
      inc(col)
    End
  Until col > maxcol;
  {determine the minimum input column width}
  minwidth:=0;
  For col:= 1 To maxcol Do
    minwidth:=Minwidth+coldata[col,width]+fldlength+4;
  minwidth:=minwidth-2;
  If minwidth > 80 Then halt;
  {select the location of the field labels and the input fields}
  gap:=2+(80-minwidth) Div maxcol;
  For col:=1 To maxcol Do
    Begin
      If col = 1 Then
        coldata[col,lblcol]:=1
      Else
        coldata[col,lblcol]:=coldata[col-1,lblcol]+coldata[col-1,width]
                             +2+fldlength+gap;
      coldata[col,fldcol]:=coldata[col,lblcol]+coldata[col,width]+2;
    End
End;

{ The following procedure initializes for each field number the values for
  the next field numbers that are associated with the directions up, down,
  left, and right in the nextfld array.  These values dicates which field
  is to be edited next based on the last field number (fldnum) and the edit
  direction command (up, down, left, or right). }

Procedure nextfldinit(Var nextfld:nextfldtype;maxrow,maxfld:Byte);

Var fullcol,fldnum,nextfldnum: Shortint;
    toprow,btmrow,firstcol,lastcol: Boolean;

Begin
  fullcol:=maxfld div maxrow;
  toprow:=True;
  btmrow:=False;
  firstcol:=True;
  lastcol:=False;
  For fldnum:=1 to maxfld Do
    Begin
      {find up for fldnum}
      If toprow Then
        If fldnum+maxrow < maxfld Then
          nextfld[fldnum,up]:=fldnum+maxrow-1
        Else nextfld[fldnum,up]:=maxfld
      Else nextfld[fldnum,up]:=fldnum-1;
      {find down for fldnum}
      If btmrow Then
        If (fldnum = maxfld) And (maxcol > fullcol) Then
          nextfld[fldnum,down]:=fullcol*maxrow+1
        Else nextfld[fldnum,down]:=fldnum-maxrow+1
      Else nextfld[fldnum,down]:=fldnum+1;
      {find left for fldnum}
      If firstcol Then
        nextfldnum:=fldnum+fullcol*maxrow
      Else nextfldnum:=fldnum-maxrow;
      If nextfldnum > maxfld Then
        nextfldnum:=nextfldnum-maxrow;
      nextfld[fldnum,left]:=nextfldnum;
      {find right for fldnum}
      If lastcol Then
        nextfldnum:=fldnum-fullcol*maxrow
      Else nextfldnum:=fldnum+maxrow;
      If nextfldnum < 1 Then
        nextfldnum:=nextfldnum+maxrow;
      nextfld[fldnum,right]:=nextfldnum;
      {set flags for next pass}
      If fldnum mod maxrow = 0 Then toprow:=True
      Else toprow:=False;
      If ((fldnum+1) mod maxrow = 0) or ((fldnum+1) = maxfld) Then
        btmrow:=True
      Else btmrow:=False;
      If (fldnum+1) <= maxrow Then firstcol:=True
      Else firstcol:=False;
      If (fldnum+1) > (maxfld-maxrow) Then lastcol:=True
      Else lastcol:=False;
    End
End;

Procedure beep;              { Routine to make error sound }

Begin
  Write(chr(7))
End;


Begin
  fldlabel[1]:= 'Hydrogen';        compmw[1]:=   2.016;
  fldlabel[2]:= 'Nitrogen';        compmw[2]:=  28.013;
  fldlabel[3]:= 'Oxygen';          compmw[3]:=  31.999;
  fldlabel[4]:= 'Water';           compmw[4]:=  18.015;
  fldlabel[5]:= 'Carbon Monoxide'; compmw[5]:=  18.010;
  fldlabel[6]:= 'Carbon Dioxide';  compmw[6]:=  44.010;
  fldlabel[7]:= 'Hydrogen Sulfide';compmw[7]:=  34.076;
  fldlabel[8]:= 'Sulfur Dioxide';  compmw[8]:=  64.059;
  fldlabel[9]:= 'Benzene';         compmw[9]:=  78.114;
  fldlabel[10]:='Toluene';         compmw[10]:= 92.141;
  fldlabel[11]:='Methane';         compmw[11]:= 16.043;
  fldlabel[12]:='Ethane';          compmw[12]:= 30.070;
  fldlabel[13]:='Propane';         compmw[13]:= 44.097;
  fldlabel[14]:='i-Butane';        compmw[14]:= 58.124;
  fldlabel[15]:='n-Butane';        compmw[15]:= 58.124;
  fldlabel[16]:='Neopentane';      compmw[16]:= 72.151;
  fldlabel[17]:='i-Pentane';       compmw[17]:= 72.151;
  fldlabel[18]:='n-Pentane';       compmw[18]:= 72.151;
  fldlabel[19]:='n-Hexane';        compmw[19]:= 86.178;
  fldlabel[20]:='n-Heptane';       compmw[20]:=100.205;
  fldlabel[21]:='Ethylene';        compmw[21]:= 28.054;
  fldlabel[22]:='Propylene';       compmw[22]:= 42.081;
  fldlabel[23]:='i-Butene';        compmw[23]:= 56.108;
  fldlabel[24]:='1-Butene';        compmw[24]:= 56.108;
  fldlabel[25]:='t-2-Butene';      compmw[25]:= 56.108;
  fldlabel[26]:='c-2-Butene';      compmw[26]:= 56.108;
  fldlabel[27]:='1-Pentene';       compmw[27]:= 70.135;
  fldlabel[28]:='1,3-Butadiene';   compmw[28]:= 54.092;

  reversevideo:=False;       { Use block markers rather than reverse video }
  zerovoid:=False;           { A zero entry is accepted in manditory field }
  hitxtcolor:=Yellow;        { Select yellow as high intensity text color }
  lotxtcolor:=LightGray;     { Select light gray as low intensity text color }
  txtbkgnd:=Black;           { Select black as background color }
  cursor(hidden);            { Hide cursor }
  TextMode(CO80);            { Set text mode to medium resolution color }
  TextColor(lotxtcolor);     { Set text color }
  TextBackground(txtbkgnd);  { Set text background color }

  titlerow:=2;
  headrow:=4;
  outputrow:=21;
  maxrow:=10;
  maxfld:=maxitemnum;
  fldlength:=7;
  freerows:=outputrow-1-headrow;
  If maxrow > freerows Then halt;
  fldrow:=headrow+1+(freerows-maxrow) Div 2;
  If (maxfld Mod maxrow) = 0 Then
    maxcol:=maxfld Div maxrow
  Else
    maxcol:=(maxfld Div maxrow)+1;

  colposinit(coldata,maxfld,maxrow,maxcol,fldlength,fldlabel);
  nextfldinit(nextfld,maxrow,maxfld);

  maxcompnum:=maxitemnum;

  Repeat

    { Clear screen and initialize component mass flow array }
    ClrScr;
    For compnumber:=1 To maxcompnum Do compmassflow[compnumber]:=0;

    { Write title for screen }
    text:='Refinery Gas Molecular Weight';
    GotoXY(39-(length(text) Div 2),titlerow);
    Write(text);
    text:='Enter component flow rates in lbs/hr:';
    GotoXY(1,headrow);
    Write(text);

    { Set location parameters for field labels (item names) }
    col:=1;
    rowcount:=0;
    itemnumber:=0;

    { Write field labels (item names) to screen }
    Repeat
      Repeat
        GotoXY(coldata[col,lblcol],fldrow+rowcount);
        inc(itemnumber);
        If itemnumber <= maxitemnum Then Write(fldlabel[itemnumber]);
        Inc(rowcount);
      Until rowcount = maxrow;
      Inc(col);
      rowcount:=0
    Until itemnumber >= maxitemnum;

    { Set location parameters for fields }
    decpla:=0;
    fldnum:=1;
    firstpass:=True;

    Repeat  { Field operations until user accepts data screen or exits }

      Repeat  { Data entry until return key sets field number to zero }

        { Calculate column and row for field number }
        If (fldnum Mod maxrow) = 0 Then
          Begin
            col:=fldnum Div maxrow;
            row:=fldrow-1+maxrow
          End
        Else
          Begin
            col:=fldnum Div maxrow +1;
            row:=fldrow-1+fldnum-maxrow*(col-1)
          End;

        { Field3 function to enter/edit/accept data }
        returnkey:=editfield(coldata[col,fldcol],    { Column }
                             row,                    { Row }
                             fldlength,              { Field length }
                             decpla,                 { Decimal places }
                             usndec,                 { Field type }
                             optional,               { Entry required }
                             compmassflow[fldnum]);  { Variable name }

        { Calculate molar flow of component }
        compmoleflow[fldnum]:=compmassflow[fldnum]/compmw[fldnum];

        { Select next field number to process on basis of return key used }
        Case returnkey Of
          enterkey:                              { Move through fields in   }
              If fldnum < maxfld                 { numerical order and quit }
              Then Inc(fldnum)                   { after the last field is  }
              Else fldnum:=0;                    { entered.                 }
          uparrowkey:
              fldnum:=nextfld[fldnum,up];        { Move up to next field    }
          dnarrowkey:
              fldnum:=nextfld[fldnum,down];      { Move down to next field  }
          tabkey:
              fldnum:=nextfld[fldnum,right];     { Move right to next field }
          shiftabkey:
              fldnum:=nextfld[fldnum,left];      { Move left to next field  }
          esckey:
              If firstpass                       { Beep on first pass       }
              Then beep
              Else fldnum:=0                     { Quit editing thereafter  }
          Else
        End;

      Until fldnum = 0;  { Data entry/editing is complete }

      { Calculate molecular weight of mixture }
      totalmassflow:=0;
      totalmoleflow:=0;
      For compnumber:= 1 To maxcompnum Do
        Begin
          totalmassflow:=totalmassflow+compmassflow[compnumber];
          totalmoleflow:=totalmoleflow+compmoleflow[compnumber]
        End;
      If totalmoleflow <> 0 Then
        moleweight:=totalmassflow/totalmoleflow
      Else moleweight:=0;

      { Field3 procedure to display choices for user }
      note('END to Accept, ENTER to Edit, ESC to exit');

      Repeat  { Key input until choice is made }

        { Field3 function to get code for special key }
        returnkey:=getspecialkey;
        If (returnkey <> endkey) And
           (returnkey <> enterkey) And
           (returnkey <> esckey)
        Then
          { Field3 procedure to display error message }
          errmsg('Must be END (Accept), ENTER (Edit), Or ESC (Exit)')
      Until  { User choses next action }
           (returnkey = endkey) Or
           (returnkey = enterkey) Or
           (returnkey = esckey);

      If returnkey = enterkey Then
        { Return to data entry/editing }
        Begin
          firstpass:=False;
          fldnum:=1;
          { Field3 procedure to display choices for user }
          note('Use '#24', '#25', TAB, and Shft-TAB keys to select field; ESC to Exit')
        End;
    Until  { User accepts screen data or exits }
         (returnkey = endkey) Or
         (returnkey = esckey);

    If returnkey = endkey Then
      Begin
        { Write results to screen }
        GotoXY(1,outputrow);
        Write('Total Stream Flow Rate lb/hr =      ',totalmassflow:10:0);
        GotoXY(1,outputrow+1);
        Write('Total Stream Flow Rate, lb-moles/hr = ',totalmoleflow:8:1);
        GotoXY(1,outputrow+2);
        Write('Total Stream Molecular Weight =        ',moleweight:7:3);

        { Field3 procedure to display choices for user }
        note('ENTER to Run Another Case, or ESC to Exit');

        While ((returnkey <> enterkey) And (returnkey <> esckey)) Do
          Begin
            { Field3 function to get code for special key }
            returnkey:=getspecialkey;
            If ((returnkey <> enterkey) And (returnkey <> esckey)) Then
              { Field3 procedure to display error message }
              errmsg('Must be ENTER (New Case), or ESC (Exit)')
          End;
        noteactive:=False
      End;
  Until returnkey = esckey;  { User exits }
  cursor(underline);
  NormVideo;
  ClrScr;
End.
