program gdemo;
(* demo program where we redefine all the character colors and then put them *)
(* on the screen *)

uses crt,graph,fegatxt;

var
   i:integer;
   graphdriver,
   graphmode,
   errorcode:integer;
   fg:fast_ega_text;
   str1:str80;



procedure Initialize;
{ Initialize graphics and report any errors that may occur }
(* from Borland's BGIDEMO *)
var
  InGraphicsMode : boolean; { Flags initialization of graphics mode }
  PathToDriver   : string;  { Stores the DOS path to *.BGI & *.CHR }
begin
  { when using Crt and graphics, turn off Crt's memory-mapped writes }
  DirectVideo := False;
  PathToDriver := '';
  repeat
    GraphDriver := Detect;                { use autodetection }
    InitGraph(GraphDriver, GraphMode, PathToDriver);
    ErrorCode := GraphResult;             { preserve error return }
    if ErrorCode <> grOK then             { error? }
    begin
      Writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
      if ErrorCode = grFileNotFound then  { Can't find driver file }
      begin
        Writeln('Enter full path to BGI driver or type <Ctrl-Break> to quit:');
        Readln(PathToDriver);
        Writeln;
      end
      else
        Halt(1);                          { Some other error: terminate }
    end;
  until ErrorCode = grOK;
  Randomize;                { init random number generator }
end; { Initialize }

begin
  initialize;
  fg.init;
  for i:=0 to 255 do
    begin
      setcolor(random(15)+1);
      outtextxy(0,0,chr(i));    (* output each character *)
      fg.getchr(1,0,i);         (* redefine the char *)
      cleardevice;              (* a slow cheap way to get rid of the old character *)
    end;
  for i:=1 to 6000 do    (* show the new characters *)
    fg.writechar(random(79)+1,random(342),chr(random(256)));
  readln;
end.

