{+------------------------------------------------------------
 | Program FETest
 |
 | Version: 1.0  Last modified: 10/06/94, 16:59:33
 | Author : P. Below [CompuServe 100113,1101]
 | Project: FETest
 | Description:
 |   This is a test program to show the function of a flexible
 |	 edit control object. This edit allows the change of window
 |	 styles "on the fly", e.g. switching from left to right align-
 |	 ment, from upper- to lowercasing or from read-only to normal
 |	 and back.
 |
 |	 For details on this control see the FLEXEDIT.PAS Unit.
 |
 |	 This control has only been tested in a dialog but it should 
 |	 work in a TWindow as well.
 |
 |	 This code is released to the public domain, use it at your
 |	 convenience and your own risk.
 |
 | Source files in this project:
 |   FETEST.PAS, FETEST.INC, FETEST.RC, FLEXEDIT.PAS
 +------------------------------------------------------------}
Program FETest;

Uses WinTypes, WinProcs, Win31, Objects, ODialogs, OWindows, BWCC,
     Flexedit;
{$R FETEST}
{$D Copyright (c) 1994 by Peter Below}

Const 
  AppName : PChar = 'FETEST';
{$I fetest.inc }
Type
  TMyApplication = Object(TApplication)
    Procedure InitMainWindow; virtual;
  End;
	(* index type for the transferbuffer *)
  TIndices = ( rb_left, rb_center, rb_right, rb_nocase, rb_uppercase,
               rb_lowercase, cb_oemconvert, cb_readonly );
  PFEditDialog = ^TFEditDialog;
  TFEditDialog = Object(TDlgWindow)
	  TheEdit: PFlexEdit;             (* demonstration object *)
		Buf    : Array [TIndices] Of Word;  (* transfer buffer *)
    Constructor Init;
    Procedure SetUpWindow; Virtual;
    Function GetClassName : PChar; Virtual;
		Procedure SetStyleButtonStates;
		Procedure Ok(var Msg: TMessage); virtual id_First + id_OK;
  End;

{************************************************************
 * Procedure CenterWindow( HWindow: THandle ); 
 *
 * Parameters:
 *	HWindow: handle of window to center
 * Description:
 *	Centers a window on the desktop
 * Error Conditions:
 *	none
 *
 *Created: 05/07/94 13:14:44 by P. Below
 ************************************************************}
Procedure CenterWindow( HWindow: THandle ); 
  Var
  	rect: TRect;
	Begin
	  GetWindowRect( HWindow, rect );
		SetWindowPos( HWindow, HWND_TOP,
		    ( GetSystemMetrics( SM_CXSCREEN ) - rect.right + rect.left) shr 1,
		    ( GetSystemMetrics( SM_CYSCREEN ) - rect.bottom + rect.top) shr 1,
		    0, 0, SWP_NOSIZE or SWP_NOZORDER );
	End; { CenterWindow }

{--------------------------------------------------}
{ TFEditDialog's methods                           }
{--------------------------------------------------}

{************************************************************
 * TFEditDialog.Init
 *
 * Parameters:
 *	none 
 * Description:
 *	Standard Init constructor, first calls the inherited Init,
 *	then sets up the transfer buffer for the radiobuttons and
 *	checkboxes. The TheEdit field is connected to the TFlexEdit
 *	object to test. 
 * Error Conditions:
 *	may fail in the inherited method. Trust to faith that the
 *	child objects are all created ok.
 *
 *Created: 10/06/94 17:24:38 by P. Below
 ************************************************************}
Constructor TFEditDialog.Init;
	Var
		PR: PRadioButton;
		PC: PCheckbox;
  Begin
    inherited Init(nil, AppName);
		If Status >= 0 Then Begin
			FillChar( Buf, Sizeof( Buf), 0 );
			TransferBuffer := @Buf;
			New( TheEdit, InitResource( @Self, ID_EDIT, 1024 ));
			If Assigned( TheEdit) Then 
			  TheEdit^.DisableTransfer;
			New( PR, InitResource( @Self, ID_LEFT ));
			New( PR, InitResource( @Self, ID_CENTER ));
			New( PR, InitResource( @Self, ID_RIGHT ));
			New( PR, InitResource( @Self, ID_NOCASING ));
			New( PR, InitResource( @Self, ID_UPPERCASE ));
			New( PR, InitResource( @Self, ID_LOWERCASE ));
			New( PC, InitResource( @Self, ID_OEMCONVERT ));
			New( PC, InitResource( @Self, ID_READONLY ));
		End;
  End;

{************************************************************
 * TFEditDialog.SetUpWindow
 *
 * Parameters:
 *	none
 * Description:
 *	Calls the inherited method and then sets the radiobuttons and
 *	checkboxes according to the style of the edit control as 
 *	created from the resource template and then centers the dialog
 *	on the desktop.
 *	We run into a problem here, which will revisit us repeatedly:
 *	the Windows Edit control strips the WS_BORDER style from the
 *	window style because it paints the border itself, not as part 
 *	of the normal WM_NCPAINT processing. We just assume that an 
 *	edit will allways have a border. 
 * Error Conditions:
 *	none
 *
 *Created: 10/06/94 17:32:08 by P. Below
 ************************************************************}
Procedure TFEditDialog.SetUpWindow;
  Begin
    inherited SetUpWindow;
		TheEdit^.Attr.Style := GetWindowLong( TheEdit^.HWindow, GWL_STYLE )
		                       or WS_BORDER;
		SetStylebuttonStates;
		CenterWindow( Hwindow );
  End;

{************************************************************
 * TFEditDialog.SetStyleButtonStates
 *
 * Parameters:
 *	none
 * Description:
 *	Evaluates the style of our edit control and sets the states
 *	of the radiobuttons and checkbuttons accordingly. This method
 *	is only called once from SetupWindow.
 *	Since Windows ignores the es_readonly style unless the app is
 *	marked for Win 3.1 usage only, we send em_setreadonly messages
 *	to really get the wanted behaviour.
 * Error Conditions:
 *	none
 *
 *Created: 10/06/94 17:38:14 by P. Below
 ************************************************************}
Procedure TFEditDialog.SetStyleButtonStates;
  Var
  	style : LongInt;
  Begin
  	style := TheEdit^.Attr.Style;
		FillChar( Buf, Sizeof( Buf ), bf_unchecked );
		If ( style and es_center ) <> 0 Then
		  Buf[rb_center] := bf_checked
		Else
			If ( style and es_right ) <> 0 Then
			  Buf[rb_right] := bf_checked
			Else
			  Buf[ rb_left ] := bf_checked;
		If ( style and es_uppercase ) <> 0 Then
		  Buf[rb_uppercase] := bf_checked
		Else
			If ( style and es_lowercase ) <> 0 Then
			  Buf[rb_lowercase] := bf_checked
			Else
			  Buf[rb_nocase] := bf_checked;
		If ( style and es_oemconvert ) <> 0 Then
		  Buf[cb_oemconvert] := bf_checked;
		If ( style and es_readonly ) <> 0 Then Begin
		  Buf[ cb_readonly ] := bf_checked;
			SendDlgItemMsg( ID_EDIT, EM_SETREADONLY, Ord( True ), 0 );
		End
		Else
			SendDlgItemMsg( ID_EDIT, EM_SETREADONLY, Ord( False ), 0 );
    TransferData( tf_setdata );
  End; (* TFEditDialog.SetStyleButtonStates *)

{************************************************************
 * TFEditDialog.Ok
 *
 * Parameters:
 *	msg: Standard message record
 * Returns:
 *	msg.result = 0
 * Description:
 *	This method gets called if the "Change" button is pressed.
 *	It evaluates the current settings of radiobuttons and check-
 *	boxes to form a new style for the edit control and then 
 *	instructs the control to change its style accordingly.
 * Error Conditions:
 *	The style change may fail due to lack of memory. In this
 *	case, a message box is displayed.
 *
 *Created: 10/06/94 17:41:37 by P. Below
 ************************************************************}
Procedure TFEditDialog.Ok(var Msg: TMessage); 
  Var
  	oldstyle, newstyle : LongInt;
  Begin
  	msg.result := 0;
		TransferData( tf_GetData );
    oldstyle := TheEdit^.Attr.Style or WS_BORDER;
		newstyle := oldstyle and not
		              ( es_right or es_center or es_uppercase or
		                es_lowercase or es_oemconvert or es_readonly );
    If ( Buf[rb_center] and bf_checked ) <> 0 Then
		  newstyle := newstyle or es_center
		Else
		  If ( Buf[rb_right] and bf_checked ) <> 0 Then
		    newstyle := newstyle or es_right;
    If ( Buf[rb_uppercase] and bf_checked ) <> 0 Then
		  newstyle := newstyle or es_uppercase
		Else
		  If ( Buf[rb_lowercase] and bf_checked ) <> 0 Then
		    newstyle := newstyle or es_lowercase;
    If ( Buf[cb_oemconvert] and bf_checked ) <> 0 Then
		  newstyle := newstyle or es_oemconvert;
    If ( Buf[cb_readonly] and bf_checked ) <> 0 Then
		  newstyle := newstyle or es_readonly;

    If oldstyle <> newstyle Then 
		  If not TheEdit^.SetNewStyle( newstyle ) Then
			  MessageBox( Hwindow, 'SetNewStyle failed!', 'Error!',
			              MB_OK or MB_ICONSTOP );
  End; (* TFEditDialog.Ok *)

Function TFEditDialog.GetClassName;
  (* return the name of the dialog templates class *)
  Begin
    GetClassName := 'BorDlg_1';
  End;

{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}
Procedure TMyApplication.InitMainWindow;
  Begin
    MainWindow := New(PFEditDialog, Init);
  End;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}
Var 
  MyApp: TMyApplication;
Begin
  MyApp.Init(AppName);
  MyApp.Run;
  MyApp.Done;
End.
