program FCopy;
{ FCopy - A demo program for the FileCopy unit
  version 1.1  4/20/88
  by Richard S. Sadowsky

  Released to the public domain

  USAGE:

  FCOPY source dest
  copies file specified by source into file specified by dest.  Souce and dest
  MUST be complete file names (with path if desired).
  In other words, this is unacceptable:
    FCOPY FCOPY.PAS A:
  Instead, you would do:
    FCOPY FCOPY.PAS A:FCOPY.PAS

  See FILECOPY.PAS for source to the filecopy unit.
}
uses FileCopy;

var
  ErrorCode : Word;

begin
  if ParamCount < 2 then begin { make sure user gave us two file names }
    WriteLn('FCOPY SourcePath DestPath'); { show syntax }
    Halt(1)                               { and abort   }
  end;

  ErrorCode := File_Copy(ParamStr(1),ParamStr(2),$FFFF); { copy 'em }
  { use as big a copy buffer as possible }

  if ErrorCode = 0 then
    WriteLn('Copied!') { WE MADE IT! }
  else
    WriteLn('Error #',ErrorCode); { whoops }
end.
