
Unit MOUSEA0;

INTERFACE

Uses DOS;

Const
  MDD  = $33;                    {Intr for mouse device driver          }


Type
  ResetRec =  record
    exists    :  boolean;
    nButtons  :  integer;
  end;

  LocRec   =  record
    buttonStatus,
    opCount,

    column,
    row       :  integer;
  end;

  MoveRec  =  record
    hCount,
    vCount    :  integer;
  end;

  mEvent   =  record
    event,
    btnStatus,
    horiz,
    vert      : word;
  end;

  mButtons_type = record
    Left,
    Middle,
    Right     : Boolean;
  end;

Var
  Reg         : Registers;
  HideCount   : integer;

  mmsg        : string;
  CheckMouse  : Boolean;
  mISR        : Boolean;

  m           : resetRec;
  mous        : mEvent;
  mButtons    : mButtons_type;

(*********************************************************************)


Procedure mReset (var mouse :resetRec);                { function   0 }
Procedure mShow;                                       { function   1 }
Procedure mHide;                                       { function   2 }
Procedure mPos (var mouse : locRec);                   { function   3 }
Procedure mMoveto (col, row : integer);                { function   4 }
Procedure mPressed (button : integer;                  { function   5 }
                    var mouse :locRec);
Procedure mReleased (button : integer;                 { function   6 }
                     var mouse :locRec);
Procedure mColRange (min, max : integer);              { function   7 }
Procedure mRowRange (min, max : integer);              { function   8 }
Procedure mGraphCursor (hHot, vHot :integer;           { function   9 }
                        maskSeg, maskOfs : word);
Procedure mTextCursor (ctype, p1, p2 : word);          { function  10 }
Procedure mMotion (var moved : moveRec);               { function  11 }
Procedure mInstTask (mask,                             { function  12 }
                     taskSeg, taskOfs : word);
Procedure mLpenON;                                     { function  13 }
Procedure mLpenOff;                                    { function  14 }
Procedure mRatio (horiz, vert : integer);              { function  15 }

(*-------------------------------------------------------------------*)
{Added Functions and Procedures}

Function mHidden : Boolean;               {# = 0 mouse visible        }
Procedure Enable_mISR (mask : byte);      {Enables  CheckMouse by Intr}
Procedure Disable_mISR;                   {Disables CheckMouse        }

(*********************************************************************)


IMPLEMENTATION

Function lower (n1, n2 : integer ) : integer;
 begin
   If n1 < n2 then lower := n1
     else lower := n2;
 end;

Function upper (n1, n2 : integer ) : integer;
 begin
   If n1 > n2 then upper := n1
     else upper := n2;
 end;


(*-------------------------------------------*)


{function 0}
Procedure mReset;
Begin
  reg.ax := 0;
  intr (MDD,reg);
  if reg.ax <> 0 then
    mouse.exists := true
  else
    mouse.exists := False;
  mouse.nButtons := reg.bx;

  HideCount := HideCount -1;
end;


{function 1}
Procedure mShow;
Begin
  reg.ax := 1;
  intr (MDD,reg);

  HideCount := HideCount +1;
end;


{function 2}
Procedure mHide;
Begin
  reg.ax := 2;
  intr (MDD,reg);

  HideCount := HideCount -1;
end;


{function 3}
Procedure mPos;
Begin
  reg.ax := 3;
  intr(MDD,reg);
  mouse.buttonStatus := reg.bx;
  mouse.column := reg.cx;
  mouse.row := reg.dx;
end;


{function 4}
Procedure mMoveto;
Begin
  reg.ax := 4;
  reg.cx := col;
  reg.dx := row;
  intr (MDD,reg);
end;



{function 5}
Procedure mPressed;
Begin
  reg.ax := 5;
  reg.bx := button;
  intr (MDD,reg);
  mouse.buttonStatus := reg.ax;
  mouse.opCount := reg.bx;
  mouse.column := reg.cx;
  mouse.row := reg.dx;
end;


{function 6}
Procedure mReleased;
Begin
  reg.ax := 6;
  reg.bx := button;
  intr (MDD,reg);
  mouse.buttonStatus := reg.ax;
  mouse.opCount := reg.bx;
  mouse.column := reg.cx;
  mouse.row := reg.dx;
end;


{function 7}
Procedure mColRange;
Begin
  reg.ax := 7;
  reg.cx := lower (min,max);
  reg.dx := upper (min,max);
  intr (MDD,reg);
end;


{function 8}
Procedure mRowRange;
Begin
  reg.ax := 8;
  reg.cx := lower (min,max);
  reg.dx := upper (min,max);
  intr (MDD,reg);
end;


{function 9}
Procedure mGraphCursor;
Begin
  reg.ax := 9;
  reg.bx := hHot;
  reg.cx := vHot;
  reg.dx := maskOfs;
  reg.es := maskSeg;
  intr (MDD,reg);
end;


{function 10}
Procedure mTextCursor;

{NOTE:                                                                 }
{       Type 0 is the software cursor.  When specified, p1             }
{         and p2 are the screen and cursor masks.                      }
{       Type 1 is the hardware cursor.  When specified, p1             }
{         and p2 are the start and stop scan lines, i.e.               }
{         the cursor shape.                                            }

Begin
  reg.ax := 10;
  reg.bx := ctype;
  reg.cx := p1;
  reg.dx := p2;
  intr (MDD,reg);
end;


{function 11}
Procedure mMotion;

{NOTE:                                                                 }
{       Net movement of mouse since last call                          }
{       Expressed in mickeys (1/100")                                  }

Begin
  reg.ax := 11;
  intr (MDD,reg);
  moved.hCount := reg.cx;
  moved.vCount := reg.dx;
end;


{function 12}
Procedure mInstTask;

{NOTE:                                                                 }
{       Install user-defined task.                                     }
{       Called procedure must be compiled as a far call                }
{                                                                      }
{       Mask byte for ISR mouse events:                                }
{                                                                      }
{       Bit           Event                                            }
{        0              Mouse cursor moved                             }
{        1              Left button pressed                            }
{        2              Left button released                           }
{        3              Right button pressed                           }
{        4              Right button released                          }
{        5              Middle button pressed                          }
{        6              Middle button released                         }


Begin
  reg.ax := 12;
  reg.cx := mask;
  reg.dx := taskOfs;
  reg.es := taskSeg;
  intr (MDD,reg);
end;




{function 13}
Procedure mLpenOn;
Begin
  reg.ax := 14;
  intr (MDD,reg);
end;


{function 14}
Procedure mLpenOff;
Begin
  reg.ax := 15;
  intr(MDD,reg);
end;


{function 15}
Procedure mRatio;

{NOTE:                                                                 }
{                                                                      }
{        Ratios are R/8                                                }
{        Default is 16 for vertical, 8 for horizontal                  }


Begin
  reg.ax := 15;
  reg.cx := horiz;
  reg.dx := vert;
  intr(MDD,reg);
end;

{------------------------------------------------------------}


{$F+}

Procedure mHandler (Flags,IP,AX,BX,CX,DX,DI,DS,ES,BP : WORD);

INTERRUPT;

Begin
    mous.event          := AX;
    mous.btnStatus      := BX;
    mous.horiz          := CX;
    mous.vert           := DX;


  CheckMouse := True;


  inline (
    $8B/$E5/
    $5D/
    $07/
    $1F/
    $5F/
    $5E/
    $5A/
    $59/
    $5B/
    $58/
    $CB );
end; {mHandler}


Procedure Enable_mISR;
Begin
  mInstTask (mask,Seg(mHandler),Ofs(mHandler) );
  mISR := True;
end; {Enable_mISR}

Procedure Disable_mISR;
Begin
  mInstTask ($00,Seg(mHandler),Ofs(mHandler) );
  mISR := False;
end; {Disable_mISR}

{$F-}


Function mHidden;
Begin
  if HideCount < 0 then mHidden := True
    else mHidden := False;
end;



{---------------------Begin Init. of Unit---------------------}

BEGIN   {Unit initialization process}
  HideCount := 0;

  mReset(m);
  If m.exists then mmsg := 'MOUSE HANDLER INSTALLED'
    else mmsg := 'NO MOUSE INSTALLED or ERROR IN MOUSE DRIVER';

  mous.event  := 0;
  mISR        := False;


END.  {Unit MOUSEA0.PAS}

