
Program  mousdemo;   {Demo of the mouse unit}


Uses dos, crt, mouse_A0;

Const
  hardware  = 1;           {cursor types                               }
  software  = 0;
  Left      = 0;           {mouse buttons                              }
  Right     = 1;

Var
  theMouse  : resetRec;    {for mouse fcn 0                            }
  its       : LocRec;      {for mouse inquiries                        }
  col,row   : integer;
  input     : string[80];


Begin
  ClrScr;
  mReset (theMouse);       {initalize the mouse                        }
  If theMouse.exists Then

{Do the software mouse demo first}

  Begin
    Writeln ('Software cursor:');
    Writeln ('Demo of a mouse with ',
              theMouse.nButtons, 'buttons');
    Writeln ('Move the mouse around and click the left button');
    Writeln ('Click the right button for hardware mouse demo');
    Writeln;
    mTextCursor (software, $0000, $0718);  {set s/w cursor}
    mShow;

    Repeat
      If its.opcount > 0 then Begin
         mHide;
         Writeln('Mouse is at column',its.column,
                 ', row', its.row);
         mShow;
      end; {if}
      mReleased (right, its);
    Until its.opCount > 0;

{Now do the hardware mouse demo}

    ClrScr;
    Writeln('Hardware cursor:');
    Writeln('Move the mouse, click left button');
    Writeln('Type something and press Enter');
    Writeln('Click right button to end demo');

    mReset (theMouse);
    mTextCursor (hardware,2,5) {set h/w cursor as small block}
    mShow;
    Repeat
      mReleased (left,its);
       If its.opCount > then begin
         col := its.column DIV 8;
         row := its.row DIV 8;
         GotoXY(col, row);
         Write('?');
         Readln(input);
         mMoveto (its.column,its.row);
       end; {if}
       mReleased (right, its);
    Until its.count > 0;

{Clean up afterwards}
    mTextCursor (hardware,6,7); {if graphics board, else 11,12}
    mRest (theMouse);
    ClrScr;
  End
 else
    Writeln('Mouse not present in system');

End.


