
Unit MOUSEA1;

INTERFACE

Uses DOS, MOUSEA0;

Const
  SwitchOn        =  $FF;
  SwitchOff       =  $00;

  JoyWeight : integer =  3;

  JoyX            =  $1300;
  JoyY            =  $1301;
  KnobA           =  $1302;
  KnobB           =  $1303;
  PalmSwitch      =  $1304;

  Xmax : byte  =  256;
  Xmin : byte  =    1;
  Ymax : byte  =  256;
  Ymin : byte  =    1;


Var
  Joy_PosX, Joy_PosY,
  KnobA_Pos,KnobB_Pos  : byte;


(*********************************************************************)

Procedure UpdateMouse;


(*********************************************************************)


IMPLEMENTATION

Procedure Reset_Joystick;

begin

  Port[KnobA]  := $00;  {start at 0}
  Port[KnobB]  := $00;

  Port[JoyX]   := $80;  {start at middle}
  Port[JoyY]   := $80;

  Port[PalmSwitch] := SwitchOff;

end; {Reset_Joystick}


Procedure UpdateMouse;

 {internal function}
 function bounds(current,added: integer) : integer;
 const
   lo_val  = 0;
   hi_val  = 255;
 var
   temp  : integer;


begin
  if added > JoyWeight then added := added DIV JoyWeight;

  temp := current + added;
  if temp < lo_val then temp := lo_val
    else
  if temp > hi_val then temp := hi_val;

  bounds := temp;
end; {bounds}



var

moved  : moveRec;
amouse : locRec;

begin

  mMotion(moved);

  if mButtons.Left then begin

     Joy_PosX := bounds(Joy_PosX , moved.hCount);
     Port[JoyX] := Ord(Joy_PosX);

     Joy_PosY := bounds(Joy_PosY , moved.vCount);
     Port[JoyY] := Ord(Joy_PosY);

     end else

  if mButtons.Middle then begin

     KnobA_Pos := bounds(KnobA_Pos , moved.hCount);
     Port[KnobA] := Ord(KnobA_Pos);

     KnobB_Pos := bounds(KnobB_Pos , moved.vCount);
     Port[KnobB] := Ord(KnobB_Pos);

     end;



  mPos (amouse);

  if (amouse.buttonStatus AND $01 = $01) then mButtons.Left   := True
      else mButtons.Left := False;
  if (amouse.buttonStatus AND $02 = $02) then mButtons.Right  := True
      else mButtons.Right := False;
  if (amouse.buttonStatus AND $04 = $04) then mButtons.Middle := True
      else mButtons.Middle := False;

  amouse.buttonStatus := 0;



end;  {UpdateMouse}



BEGIN   {unit initalization process}

  mButtons.Left   := False;
  mButtons.Middle := False;
  mButtons.Right  := False;

  Joy_PosX        := 128;
  Joy_PosY        := 128;
  KnobA_Pos       := 100;
  KnobB_Pos       :=   0;

END.    {Unit}

