{$A+,B+,D+,E-,F-,G-,I+,L+,N-,O-,R+,S+,V+,X+}
{$M 16384,0,655360}
Program enhMenusDemonstration;
Uses App, Objects, Drivers, Views, enhMenus;

Type
   PHelpWindow               =   ^enhHelpWindow;
   enhHelpWindow             =   Object (TWindow)
                                    Constructor  Init(InView:PView; aTitle:String; Modal:Boolean);
                                    Procedure    HandleEvent(var Event:TEvent); virtual;
                                 End;

   PStatusLine               =   ^enhStatusLine;
   enhStatusLine             =   Object (TStatusLine)
                                    Function     Hint(aHelpCtx:Word):String; virtual;
                                 End;
   enhMenusDemo              =   Object (TApplication)
                                    Procedure    InitMenuBar; virtual;
                                    Procedure    InitStatusLine; virtual;
                                    Procedure    HandleEvent(var Event:TEvent); virtual;
                                    Procedure    GetEvent(var Event:TEvent); virtual;
                                 End;

Const
   hcFile                    =   5000;
   hcOpen                    =   5001;
   hcSave                    =   5002;
   hcChangeDir               =   5003;
   hcExit                    =   5004;
   hcMenu                    =   5005;

   hcSubMenu                 =   5100;
   hcValid                   =   5101;
   hcCancel                  =   5102;

   hcHelpContents            =   1000;
   hcHelpIndex               =   1001;
   hcHelpTopic               =   1002;
   hcHelpPrevious            =   1003;
   hcHelpHelp                =   1004;
   hcHelp                    =   1005;

   hcHelpWindow              =   1100;

   cmSave                    =   100;
   cmOpen                    =   101;
   cmChangeDir               =   102;

   cmHelpContents            =   300;
   cmHelpIndex               =   301;
   cmHelpTopic               =   302;
   cmHelpPrevious            =   303;
   cmHelpHelp                =   304;


Constructor enhHelpWindow.Init(InView:PView; aTitle:String; Modal:Boolean);
Var
   Bounds                    :   TRect;

Begin
   InView^.GetBounds(Bounds);
   Bounds.A.X:=(Bounds.B.X-30) div 2;
   Bounds.A.Y:=(Bounds.B.Y-10) div 2;
   Bounds.B.X:=Bounds.A.X+30;
   Bounds.B.Y:=Bounds.A.Y+10;
   TWindow.Init(Bounds, aTitle, 0);
   If Modal Then
      Flags:=Flags and not (wfGrow+wfZoom);
   HelpCtx:=hcHelpWindow;
End;

Procedure enhHelpWindow.HandleEvent(var Event:TEvent);
Begin
   If (((Event.What=evKeyboard) and (Event.KeyCode=kbEsc))
      or ((Event.What=evCommand) and (Event.Command=cmClose)))
      and (State and sfModal=sfModal)
   Then Begin
      EndModal(cmClose);
      ClearEvent(Event);
   End
   Else
      TWindow.HandleEvent(Event);
End;

Function enhStatusLine.Hint(aHelpCtx:Word):String;
Var
   St                        :   String;

Begin
   Case aHelpCtx of
      hcFile:
         St:='File operations (open, save, change dir, etc...)';
      hcOpen:
         St:='Open a file';
      hcSave:
         St:='Save current file';
      hcChangeDir:
         St:='Change default directory';
      hcExit:
         St:='Exit to DOS';
      hcHelp:
         St:='Online help menu';
      hcHelpContents:
         St:='Show the help table of contents';
      hcHelpIndex:
         St:='Show the help index';
      hcHelpTopic:
         St:='Show help for the current topic';
      hcHelpPrevious:
         St:='Show previous help topic';
      hcHelpHelp:
         St:='Help overview';
      hcSubMenu:
         St:='Results of cmValid and cmCancel commands';
      hcValid:
         St:='Does NOT abort the menu';
      hcCancel:
         St:='Does abort the menu';
      Else
         St:='';
   End;
   Hint:=St;
End;

Procedure enhMenusDemo.InitMenuBar;
Var
   R                         :   TRect;

Begin
   GetExtent(R);
   R.B.Y:=R.A.Y+1;

   MenuBar := New(PMenuBar, Init(R, NewMenu(
                 NewSubMenu('~F~ile', hcFile, NewMenu(
                    NewItem('~O~pen','F3',kbF3,0,hcOpen,
                    NewItem('~S~ave','Alt-F3',kbAltF3,cmSave,hcSave,
                    NewLine(
                    NewItem('~C~hange dir...','',kbNoKey,cmChangeDir,hcChangeDir,
                    NewItem('E~x~it','Alt-X',kbAltX,cmQuit,hcExit,
                    nil)))))),
                 NewSubMenu('~M~enu', hcMenu, NewMenu(
                    NewSubMenu('~S~ubmenu', hcSubMenu, NewMenu(
                       NewItem('~V~alid command','',kbNoKey,cmValid,hcValid,
                       NewItem('~C~ancel command','',kbNoKey,cmCancel,hcCancel,
                       nil))),
                    nil)),
                 NewSubMenu('~H~elp',hcHelp,NewMenu(
                    NewItem('~C~ontents','',kbNoKey,cmHelpContents,hcHelpContents,
                    NewItem('~I~ndex','Shift-F1',kbShiftF1,cmHelpIndex,hcHelpIndex,
                    NewItem('~T~opic search','Ctrl-F1',kbCtrlF1,cmHelpTopic,hcHelpTopic,
                    NewItem('~P~revious help','Alt-F1',kbAltF1,cmHelpPrevious,hcHelpPrevious,
                    NewItem('~H~elp on help','F1',kbF1,cmHelpHelp,hcHelpHelp,
                    nil)))))),
                 NewItem('E~x~it','',kbNoKey,cmQuit,hcExit,
                 nil)))))));
End;

Procedure enhMenusDemo.InitStatusLine;
Var
   R                         :   TRect;

Begin
   GetExtent(R);
   R.A.Y:=R.B.Y-1;;

   StatusLine := New(PStatusLine, Init(R,
                    NewStatusDef(1,1,
                       NewStatusKey('~Arrows~ Move',kbNoKey,cmCancel,
                       NewStatusKey('~Shift-Arrow~ Size',kbNoKey,cmCancel,
                       NewStatusKey('~Return~ Done',kbNoKey,cmCancel,
                       NewStatusKey('~Esc~ Done',kbNokey,cmCancel,
                       nil)))),
                    NewStatusDef(0,1099,
                       NewStatusMenu('~F1~ Help',hcHelp,kbF1,NewMenu(
                          NewItem('~C~ontents','',kbNoKey,cmHelpContents,hcHelpContents,
                          NewItem('~I~ndex','Shift-F1',kbShiftF1,cmHelpIndex,hcHelpIndex,
                          NewItem('~T~opic search','Ctrl-F1',kbCtrlF1,cmHelpTopic,hcHelpTopic,
                          NewItem('~P~revious help','Alt-F1',kbAltF1,cmHelpPrevious,hcHelpPrevious,
                          NewItem('~H~elp on help','F1',kbF1,cmHelpHelp,hcHelpHelp,
                          nil)))))),
                       NewStatusKey('~Alt-F3~',kbAltF3,cmClose,
                       NewStatusKey('~F5~ Zoom',kbF5,cmZoom,
                       nil))),
                    NewStatusDef(1100,4999,
                       NewStatusKey('~F1~ Help on Help',kbF1,cmHelpHelp,
                       NewStatusKey('~Shift-F1~ Help Index',kbShiftF1,cmHelpIndex,
                       NewStatusKey('~Alt-F1~ Previous topic',kbAltF1,cmHelpPrevious,
                       nil))),
                    NewStatusDef(5000,$FFFF,
                       NewStatusKey('~F1~ Help',kbF1,cmHelpTopic,
                       nil),
                    nil))))));
End;

Procedure enhMenusDemo.GetEvent(var Event:TEvent);
Var
   W                         :   PWindow;
   Title                     :   String;

Begin
   TApplication.GetEvent(Event);
   Case Event.What of
      evCommand:
         Begin
            Case Event.Command of
               cmHelpContents:
                  Title:='Help Contents';
               cmHelpIndex:
                  Title:='Help Index';
               cmHelpTopic:
                  Title:='Help Topic';
               cmHelpPrevious:
                  Title:='Help Previous';
               cmHelpHelp:
                  Title:='Help on Help';
            End;
            Case Event.Command of
               cmHelpHelp,
               cmHelpContents,
               cmHelpIndex,
               cmHelpTopic,
               cmHelpPrevious:
                  Begin
                     If PView(Desktop)=Current Then Begin
                        W:=New(PHelpWindow, Init(Desktop, Title, False));
                        Desktop^.Insert(W);
                     End
                     Else Begin
                        W:=New(PHelpWindow, Init(@Self, Title, True));
                        ExecView(W);
                        Dispose(W, Done);
                     End;
                     ClearEvent(Event);
                  End;
            End;
         End;
   End;
End;

Procedure enhMenusDemo.HandleEvent(var Event:TEvent);
Begin
   TApplication.HandleEvent(Event);
End;

Var
   Demo                      :   enhMenusDemo;

Begin
   Demo.Init;
   Demo.Run;
   Demo.Done;
End.
