Program MakeSmall;
{
  This program takes a pcx file and shrinks it with anti-aliasing.
It optionally shows the picture on the screen as well.
  This is a good example of how EGOF can be used in text-mode. You can run it
to see the parameters in the help screen.
}

{$I-}

Uses
  EGOF,
  VgaU,
  VesaU,
  MemoryU,
  FilterU,
  PalU,
  Dos,
  CRT;

Const
  { Flags for palette type }
  Same    = 0;     { Use palette form the input file }
  Read    = 1;     { Read palette from file          }
  Grey    = 2;     { Use gray-scale palette          }
  Uniform = 3;     { Use colour cube palette         }

  Brag :Array[0..105] of Char =
   'Hi, This picture has been anti-aliased with SMALL, a demo program for EGOF by Logi R. - logir@ismennt.is '#0;
Var
  Scr,                    { Screen         }
  Small,                  { Output bitmap  }
  Big        :EBitMapP;   { Input bitmap   }
  OutPal     :PalP;       { Output palette }
  InPal,                  { Intput palette }
  ScrPal     :EPalP;      { Screen palette }
  PicX,PicY,              { Pixel on the output bitmap being processed      }
  PixX,PixY  :LongInt;    { Sub-pixel within (PicX,PicY) being processed    }
  PC         :Word;       { Pixel counter. Number of sub pixels processed   }
  R,G,B      :Byte;       { RGB triple for one sub pixel                    }
  SR,SG,SB   :LongInt;    { Total intensity of RGB values in all sub pixels }

  InFN,OutFN,
  PalFN       :String;
  XSize,YSize :Word;
  Mode        :ShortInt;
  Palette     :Byte;

  {$IFNDEF Ver60}
  Xtra        :PChar;
  {$ENDIF}

  EI :Integer;
  EB :Byte;

Procedure ECheck (Graphic:Boolean);
{ Chck for errors and if any are found display an error message and halt    }
{ Graphic tells us weather we are in graphics mode. If so we must change to }
{ text mode before destroying the RS object                                 }
Var
  EC :ShortInt;
Begin
  If IsEgofError Then Begin
    If Scr<>nil Then Begin
      If Graphic Then
        Scr^.Done;
      Dispose (Scr);
    End;
    EC := GetEgofError;
    WriteLn ('Error #',EC,' : ',EgofErrorStr[EC],'.');
    {$IFNDEF DPMI}
    If EC=EOutOfMem Then
      WriteLn ('Consider compiling to a protected-mode program');
    {$ENDIF}
    Halt;
  End;
End;


Function FileExist (FN:String):Boolean;
{ Does the file [FN] exist? }
Var
  F :File;
Begin
  Assign (F,FN);
  ReSet (F);
  If IoResult = 0 Then Begin
    If FileSize (F)>0 Then Begin
      Close (F);
      FileExist := True;
      Exit;
    End;
    Close(F);
  End;

  FileExist := False;
End;


Function AddExt (FN:PathStr; Ext:ExtStr) :PathStr;
{ Add the extension [Ext] to [FN] if one is not already present }
Var
  Dir  :DirStr;
  Name :NameStr;
  CExt :ExtStr;
Begin
  FSplit (FExpand(FN),Dir,Name,CExt);
  If CExt = '' Then
    AddExt := Dir+Name+'.'+Ext
  Else
    AddExt := Dir+Name+CExt;
End;


Function NotAName (FN :String) :Boolean;
{ Returns true if [FN] is not a valid file-name }
Var
  F :File;
Begin
  NotAName := True;

  Assign (F,FN);
  ReWrite (F);
  If (IoResult<>0) Then
    Exit;

  Close (F);
  Erase (F);
  NotAName := False;
End;

Procedure WriteSyntax;
Begin
  WriteLn;
  WriteLn (' Syntax:');
  WriteLn ('   Small <input> <output> [switches]');
  WriteLn;
  WriteLn ('   input, output = The respective filenames. PCX extention is assumed');
  WriteLn;
  WriteLn (' Switches:');
  WriteLn ('   -Xn = Set width of the output to [n].');
  WriteLn ('   -Yn = Set height of the output to [n].');
  WriteLn ('   -Vm = View the scaled picture in mode [m]. values for [m] are:');
  WriteLn ('     0 = 320x200    3 = 800x600*   a = 320x240*   d = 360x240    g = 376x282*');
  WriteLn ('     1 = 640x400    4 = 1024x768*  b = 320x400    e = 360x360    h = 376x308');
  WriteLn ('     2 = 640x480*   5 = 1280x1024  c = 320x480    f = 360x480    i = 376x564');
  WriteLn ('   -Rf = Read palette from the PCX file [f].');
  WriteLn ('   -G  = Use a palette of 256 gray tones.');
  WriteLn ('   -U  = Use a uniform palette. Ugly. Sorry.');
  WriteLn (' * Square pixels');
  WriteLn;
  WriteLn (' The size of the output defaults to the resolution of');
  WriteLn (' the video mode, or 320x200 if not shown on the screen');
End;


Procedure Error (EC :Byte; ES:String);
{ Show error message }
Begin
  WriteLn;
  Case EC of
    0 :
      Begin
        WriteLn ('  This is a demonstration program for EGOF. It will take any resonably sized');
        WriteLn ('PCX file and reduce it with full anti-alias and save it to another PCX file.');
        WriteLn ('  Written by Logi Ragnarsson.');
      End;
    1  : WriteLn ('File not found: ',ES);
    2  : WriteLn ('Output file already exists: ',ES);
    3  : WriteLn ('Small what ???');
    4  : WriteLn ('You can''t call a file ',ES);
    5  :
      Begin
        WriteLn ('  Do you think I''m having fun doing this? Let me tell you I''m not going to');
        WriteLn ('reduce this stupid picture of yours if you are not even going to look at it!!');
        WriteLn ('No way! Forget it, man!');
      End;
    6  :  WriteLn ('Hey, if you want to make the picture disappear, just delete it!');
    7  : WriteLn ('Sorry, pal. I only make small pictures.');
    8  : WriteLn ('Why don''t you check out that neat command COPY?');
    9  : WriteLn ('What''s a ',ES);
    10 : WriteLn ('What sort of video mode is ',ES);
  End;
  WriteSyntax;
  If Not EC in [0,7] Then Begin
    WriteLn;
    WriteLn;
  End;
  Halt;
End;


Function UpStr (S:String):String;
{ String to upper case }
Var
  C :Byte;
Begin
  For C := 1 To Length(S) Do
    S[C] := UpCase(S[C]);
  UpStr := S;
End;

Procedure ReadParam;
{ Read the command line }
Var
  S   :String;
  P   :Byte;
  N,E :Word;
Begin
  If ParamCount = 0 Then          { We need parameters                      }
    Error (3,'');

  S := ParamStr(1);               { Check for ? -? /? -h and -H             }
  If (S[1] = '?') Or ((S[1] in ['-','/']) And (UpCase(S[2]) In ['H','?'])) Then
    Error (0,'');

  InFN  := AddExt (S,'PCX');      { Get name of the input file (add .pcx if needed }
  If Not FileExist (InFN) Then   { Is it there ?                           }
    Error (1,InFN);

  S := UpStr(ParamStr(2));        { Get name of the output file (in upper case) }
  If S<>'NUL' Then Begin          { if it is 'NUL' then skip the output file }
    OutFN := AddExt (S,'PCX');
    If (S[1] in ['-','/']) Then   { Is it a command switch ?                }
      Error (4,OutFN);
    If FileExist (OutFN) Then     { Is it already there ?                   }
      Error (2,OutFN);
    If NotAName (OutFN) Then      
      Error (4,OutFN);
  End
  Else
    OutFN := S;                   { We'll check if OutFN is 'NUL' later     }

  XSize := 0;                     { Undefined... Yet }
  YSize := 0;
  Mode  := -1;

  Palette := Same;

  P := 2;
  Repeat
    Inc (P);
    S := ParamStr (P);
    If S[1] in ['-','/'] Then Begin
      Case UpCase(S[2]) Of
        'X' : Begin
                Val (Copy(S,3,Length(S)-2),N,E);
                If E<>0 Then Error (9,S);
                XSize := N;
              End;
        'Y' : Begin
                Val (Copy(S,3,Length(S)-2),N,E);
                If E<>0 Then Error (9,S);
                YSize := N;
              End;
        'V' : Begin
                If Length(S)<3 Then S[3] := '0';
                If (S[3]) in ['0'..'5'] Then
                  Mode := Byte(S[3])-Byte('0')
                Else Begin
                  If UpCase (S[3]) in ['A'..'I'] Then
                    Mode := Byte(UpCase(S[3]))-Byte('A')+Mode320x240
                  Else
                    Error (10,S[3]);
                End;
              End;
        'G' : Palette := Grey;
        'U' : Palette := Uniform;
        'R' : Begin
                Palette := Read;
                S := Copy (S, 3, Length(S)-2);
                PalFN := AddExt (S,'PCX');    { Get name of the input file (add .pcx if needed }
                If Not FileExist (PalFN) Then   { Is it there ?                           }
                  Error (1,PalFN);
              End;
        Else
          Error (9,S);
      End;
    End;
  Until (P=ParamCount);

  If XSize = 0 Then Begin          { Default to full width }
    If Mode=-1 Then
      XSize := 320
    Else
      XSize := ModeRes[Mode].XRes;
  End;

  If YSize = 0 Then Begin          { Default to full height }
    If Mode=-1 Then
      YSize := 200
    Else
      YSize := ModeRes[Mode].YRes;
  End;

  If (XSize<=0) Or (YSize<=0) Then      { We don't want it to disappear     }
    Error (6,'');

  If (Mode= -1) And (OutFN='NUL') then
    Error (5,'');
End;


Function MakeFileName :String;
Var
  S :PathStr;
  T :Byte;
Begin
  Repeat
    S := GetEnv ('TEMP');
    For T := 1 To 8 Do
      S := S+Char(65+Random(26));
    S := S +'.TMP';
  Until Not FileExist (S);
  MakeFileName := S;
End;


Begin
  Scr := nil;                     { So we can check it later   }
  ReadParam;                      { Interpert the command-line }
  Randomize;

  WriteLn;
  WriteLn ('Reading input file.');
  InPal := New (MemPal8P,Init);                      { Make a palette             }
  Big := MakeMemMapPCX (InFN,InPal,nil, MemAvail{2048});   { Big    := Picture }
  ECheck (False);

  Case Palette Of
    Same    : OutPal := InPal;
    Read    : Begin
                OutPal := New (MemPal8P,Init);
                MemPal8P(OutPal)^.ReadPcx (PalFN,0,0,255);  { We know it's a MemPal8 }
              End;
    Grey    : Begin
                OutPal := New (GreyPalP,Init);
              End;
    Uniform : Begin
                OutPal := New (CCubePalP,Init);
              End;
  End;

  If (Big^.XRes<XSize) Or (Big^.YRes<YSize) Then
    Error (7,'');                                      { We don't enlarge  }

  If Mode <> -1 Then Begin                            { if we want graphics }
    If (ModeRes[Mode].XRes >= XSize) And (ModeRes[Mode].YRes >= YSize) Then Begin
      Case Mode of
        Mode320x200:
          Begin { Small becomes a window onto Scr which is the actual screen }
            Scr := New (VgaP,Init);
          End;
        Mode320x240..ModeMax:
          Begin { Small becomes a window onto Scr which is the actual screen }
            Scr := New (VgaNSP,Init(Mode));
          End;
        Mode640x400..Mode1280x1024:
          Begin { Small becomes a window onto Scr which is the actual screen }
            Scr := New (VesaP,Init(Mode));
          End;
        End;
        ECheck (False);
        Small := New (WinP,Init(Scr,0,0,XSize-1,YSize-1));
        ScrPal := New (VgaPalP,Init);      { Make the screen palette object }
        OutPal^.CopyTo (ScrPal, 0, 0,255); { Copy the picture palette to it }
        Scr^.Clear (ScrPal^.GetClosest (10,10,10)); { Clear to dark gray    }
      End
    Else Begin
      Mode := -1;  { It's too big man, we'll skip the screen thing       }
      WriteLn ('Picture too large for display.');
      If OutFN='NUL' Then  { If there is no output, there is no point    }
        Halt;
    End;
  End
  Else Begin                                     { If we are in text-mode }
    Small := MakeMemMap (XSize,YSize,0);              { Then Small is a memory map }
    ECheck (False);
    Write ('Reducing picture.   0%');
  End;

  If Mode<>-1 Then
    For PixX := 0 To 255 do
      Scr^.PutPix (PixX ,Scr^.YRes-1, PixX);

  { Show preview if in graphics and using same the palette }
  If (Mode<>-1) And (Palette=Same) Then
    For PicY := 0 To YSize -1 Do
      For PicX := 0 To XSize -1 Do
        Small^.PutPix (PicX,PicY,Big^.GetPix(PicX*Big^.XRes Div Small^.XRes, PicY*Big^.YRes Div Small^.YRes));

  If (XSize<>Big^.XRes) Or (YSize<>Big^.YRes) Then Begin
    For PicY := 0 To YSize -1 Do Begin              { For each pixel on small }
      For PicX := 0 To XSize -1 Do Begin
        SR := 0;                                               { Reset colour }
        SG := 0;
        SB := 0;
        PC := 0;
        { For each pixel on Big that the pixel on small represents }
        For PixX := (PicX * Big^.XRes Div Small^.XRes) To ((PicX+1) * Big^.XRes Div Small^.XRes)-1 Do
          For PixY := (PicY * Big^.YRes Div Small^.YRes) To ((PicY+1) * Big^.YRes Div Small^.YRes)-1 Do Begin
            { Get the RGP triple for this sub-pixel }
            InPal^.GetCol8 (Big^.GetPix(PixX,PixY), R,G,B);
            { Add to the RGB counters }
            Inc (SR,R);
            Inc (SG,G);
            Inc (SB,B);
            { Add to the Pixel Counter }
            Inc (PC);
          End;
        If PC>0 Then { Plot in the colour closest to average of the sub-pixels }
          Small^.PutPix (PicX,PicY, OutPal^.GetClosest8(SR Div PC, SG Div PC, SB Div PC));
      End;
      If Mode=-1 Then Begin   { Show progress if in text-mode }
        GoToXY(19,WhereY);
        Write(100*(PicY+1) Div YSize:3,'%');
      End;
      If KeyPressed And (ReadKey=#27) Then Begin
        If Mode<> -1 Then Begin       { If i graphics then }
          ScrPal^.FadeOut (0,255,16);
          Dispose (Scr,Done);         { Lose graphics-dependant objects }
          Dispose (ScrPal,Done);
        End;
        WriteLn;
        WriteLn ('Interrupted');
        Dispose (InPal,Done);
        If Palette<>Same Then
          Dispose (OutPal,Done);
        Dispose (Big,Done);           { Lose other objects  }
        Dispose (Small,Done);
        Halt (1);                     { Return errorlevel 1 }
      End;
    End;
  End;

  If Mode=-1 Then Begin
    WriteLn;
    If OutFN <> 'NUL' Then
      WriteLn ('Saving File.');
  End;

  If OutFN <> 'NUL' Then Begin  { Should we save the picture? }
    With Small^ Do
      { Save Small in a PCX file, along with PicPal and Xtra (PChar) }
      WritePcx (OutFN, 0,0, XSize,YSize, OutPal, @Brag, SizeOf(Brag));
  End;

  If Mode<> -1 Then Begin       { If i graphics then }
    ScrPal^.GetCol (0, R,G,B);
    ScrPal^.SetCol (0, 63,0,0);    { Flash red for .2 seconds }
    Delay (200);
    ScrPal^.SetCol (0, R,G,B);
    Repeat Until (ReadKey<>#0); { Wait for key-press }
    ScrPal^.FadeOut (0,255,16);
    Dispose (Scr,Done);         { Lose graphics-dependant objects }
    Dispose (ScrPal,Done);
  End;

  Dispose (InPal,Done);
  If Palette<>Same Then
    Dispose (OutPal,Done);
  Dispose (Big,Done);           { Lose other objects }
  Dispose (Small,Done);
End.