Program RemapTest;

{ Show some pictures using a uniform palette (pretty ugly)               }
{ The file-handling is abysmal, but this program is only for showing how }
{ EGOF works, so it doesn't matter (much).                               }

Uses
  EGOF,
  VesaU,
  MemoryU,
  FilterU,
  PalU,
  CRT;

Label
  BreakLoop;   { Sorry, Break statemnets are not supported in TP6 }

Var
  RS,S,SS,            { Real screen, Screen  }
  M    :EBitMapP;     { bitmap from file     }
  C :Byte;
  RTable,             { Tables for remapping }
  WTable :Array[0..255] of Byte;

  PicPal  :EPalP;     { Palette of picture   }
  ScrPal  :RealPalP;  { Palette on screen    }

  R,G,B   :Byte;

  PicNr   :Byte;
  Key     :Char;

  P       :Pointer;

Const
  NrOfPics = 3;
  Files : Array [1..NrOfPics] of String = ('EGOF.PCX',
                                           'ORCHID.PCX',
                                           'FRAC2.PCX');


Procedure ECheck (Graphic:Boolean);
{ Chck for errors and if any are found display an error message and halt    }
{ Graphic tells us weather we are in graphics mode. If so we must change to }
{ text mode before destroying the RS object                                 }
Var
  EC :ShortInt;
Begin
  If IsEgofError Then Begin
    If Graphic Then
      RS^.Done
    Else
      WriteLn;
    Dispose (RS);
    EC := GetEgofError;
    WriteLn ('Error #',EC,' : ',EgofErrorStr[EC],'.');
    ReadKey;
    Halt;
  End;
End;


Procedure RndPal (Pal:EPalP);         { Make a random palette  }
Begin
  Pal^.SetCol (0,0,0,0);
  For C := 1 To 255 Do               { Make a random palette }
    Pal^.SetCol (C,Random(64),Random(64),Random(64));
End;


Procedure UniPal (Pal:EPalP);         { Make a uniform palette }
Begin
  For R := 0 To 7 Do
    For G := 0 To 7 Do
      For B := 0 To 3 Do
        Pal^.SetCol (B+G*4+R*32, R*63 Div 7, G*63 Div 7, B*63 Div 3);
End;


Procedure ReadPic (FN :String);
Begin
  M := New (BigMemMapP,InitPcx (FN, PicPal,nil));  { Read picture }
  ECheck (True);

  For C := 0 To 255 Do Begin                       { Set the remap tables }
    PicPal^.GetCol (C, R,G,B);
    WTable[C] := ScrPal^.GetClosest (R,G,B);
  End;
(*For C := 0 To 255 Do Begin                   { We don't read the screen }
    ScrPal^.GetCol (C, R,G,B);
    RTable[C] := PicPal^.GetClosest (R,G,B);
  End; *)
End;


Procedure ShowPic;
{ Put the picture on the screen }
Begin
  S^.CopyMap (0,0, M, 0,0, M^.GetMaxX,M^.GetMaxY);
  Dispose (M,Done);
End;

Begin
  RS := New (VesaP,Init(Mode640x480));
  ECheck (False);
  SS := RS;

  S := New (RemapColP,Init(SS,@RTable,@WTable));
  ECheck (True);

  ScrPal := New (VgaPalP,Init);
  UniPal (ScrPal);    { Uniform palette }  { Use one of these three lines }
{ RndPal (ScrPal);    { Random palette  }
{ ScrPal^.ReadPal;    { Default palette }
  PicPal := New (MemPalP,Init);

  ReadPic (Files[1]);
  ECheck (True);
  For PicNr := 2 To NrOfPics Do Begin
    ShowPic;
    ReadPic (Files[PicNr]);
    ECheck (True);

    Key := ReadKey;
    If (Key=#27) Then
      GoTo BreakLoop
    Else If Key=#0 Then
      ReadKey;
  End;
  BreakLoop:

  If Key <> #27 Then Begin
    ShowPic;
    ReadKey;
  End;

  ScrPal^.FadeOut (0,255,32);
  Dispose (ScrPal,Done);
  Dispose (RS,Done);
End.