Program Julia;

{ Animate the Julia set }

Uses
  EGOF,
  FractalU,
  VgaU,
  PalU,
  CRT;

Const
  Nr = 250;   { Number of frames }

  X1 = Round(Nr*0.5);   { Where to start in the range }
  X2 = Round(Nr*0.6);   { Where to end in the range   }

  R1 = 0;               { Starting parameters }
  I1 = 0;
  R2 = -1;              { Ending parameters }
  I2 =  1;

Var
  Scr :VgaNsO;
  Pal :VgaPalO;
  Jul :JuliaO;
  X   :Word;
  R,I :Double;
  C   :Char;

Procedure RandomCol (NoR :Byte);
{ Create [NoR] random colour-ranges, but keep colour 0 black }
Var
  R1,G1,B1,
  Rl,Gl,Bl,
  R,G,B  :Byte;
  Ra     :Byte;
  TmpPal :MemPalO;
Begin
  TmpPal.Init;
  R1 := Random (63);
  G1 := Random (63);
  B1 := Random (63);

  Rl := R1;
  Gl := G1;
  Bl := B1;

  For Ra := 1 To NoR-1 Do Begin
    R := Random (63);
    G := Random (63);
    B := Random (63);

    TmpPal.Range (((Ra-1)*256 Div NoR), Rl,Gl,Bl, (Ra*256 Div NoR), R,G,B);

    Rl := R;
    Gl := G;
    Bl := B;
  End;

  TmpPal.Range (((NoR-1)*256 Div NoR), Rl,Gl,Bl, 255, R1,G1,B1);
  TmpPal.SetCol (0,0,0,0);

  TmpPal.CopyTo (@Pal,0,0,255);
  TmpPal.Done;
End;


Begin
  Scr.Init (Mode320x240);
  Pal.Init;
  RandomCol (5);

  Jul.Init (Scr.XRes, Scr.YRes, 0,0, 128);  { Create the Julia set }

  For X := X1 To X2 Do Begin
    Jul.SetParam (X/Nr*(R2-R1)+R1, X/Nr*(R2-R1)+R1);  { Change the Julia Set }
    Jul.ShowOn (@Scr, 0,0);                           { Draw the set }

    While KeyPressed Do Begin                         { Change the palette }
      C := UpCase (ReadKey);
      Case C Of
        #27      : X := X2;
        '1'..'9' : RandomCol (Byte(C)-Byte('0'));
      End;
    End;
  End;

  Repeat Until (ReadKey<>#0);       { Pause }

  Jul.Done;
  Pal.Done;
  Scr.Done;
End.