Program CheckVesa;

{ Get various information about a VESA compatible display adapter }

Uses
  EGOF,         { Excelent Graphics Object Framework!          }
  VesaU,        { Use Vesa compatible SVGAs                    }
  CRT;

Var
  Mode : Word;
  K    : Char;
  MI   : ModeInfoP;
  AI   : AdapterInfoP;
  SM   : ModeAP;

Begin
  AI := GetAdapterInfo;
  Repeat
    ClrScr;
    WriteLn ('What do you wish to hear of:');
    WriteLn;
    WriteLn ('  A - Adapter');
    WriteLn ('  ');
    WriteLn ('  1 -  640 x 400');
    WriteLn ('  2 -  640 x 480');
    WriteLn ('  3 -  800 x 600');
    WriteLn ('  4 - 1024 x 768');
    WriteLn ('  5 - 1280 x 1024');
    WriteLn ('  ');
    WriteLn ('  Q - Quit');

    Repeat
      K := UpCase(ReadKey);
    Until K in ['1'..'5','A','Q'];

    If K='A' Then Begin
      ClrScr;
      WriteAdapterInfo (AI);
      WriteLn;
      Write   ('Press [ENTER] to continue...');
      Repeat Until ReadKey=#13;
    End

    Else If K<>'Q' Then Begin
      Mode := ModeList[AVesa,Byte(K)-Byte('1')+Mode640x400]; {Get real mode nr }
      If Mode <>0 Then Begin
        ClrScr;
        MI := GetModeInfo(Mode);
        WriteModeInfo (MI);
        Dispose (MI);
        WriteLn;
        Write   ('Press [ENTER] to continue...');
        Repeat Until ReadKey=#13;
      End;
    End;
  Until K='Q';
  Dispose (AI);
End.