Program ShowPaletteFade;
{ Show how to manipulate the palette }
Uses
  VgaU,
  PalU,
  CRT;

Var
  S  :VgaO;     { Screen. 320x200 }
  SP :VgaPalO;  { Screen palette. }
  BP :MemPalO;  { Buffer palette. }
  C  :Byte;

Begin
  { Output some yellow text, and wait for a second }
  TextColor (Yellow);
  WriteLn ('Welcome to EGOF palette management. Sit back and enjoy :-)');
  Delay (500);

  { Initialise the on-screen-palette object, and read the palette }
  SP.InitRead;
  { Fade the colours 0 to 255 to black, in 128 steps }
  SP.FadeOut (0,255,64);

  { Create the screen object, and enter the 320x200-256c mode }
  S.Init;
  { The palette has changed with the mode change. Return it to black. }
  SP.BlackPal (0,255);
  { Create a buffer palette }
  BP.Init;

  { Read a picture, and put the palette in the buffer BP. }
  S.ReadPcx (0,0,'FracV.PCX',@BP,nil);
  { Fade the palette in BP to the screen. Start at colour 0 in SP, and use }
  { colours 0 to 255 on BP. Fade in 64 steps }
  BP.FadeTo (@SP,0,0,255,64);
  Delay (500);
  { Fade colours 15 to 31 to black in 64 steps }
  SP.FadeOut (15,31,128);
  { Fade colours 15 to 31 in BP to the screen starting at colour 15 }
  BP.FadeTo (@SP,15,15,31,128);
  Delay (500);

  S.Done;
End.