Program KillPal;
{ Program to remove the palette from a PCX file. the files will not load    }
{ in most programs, but EGOF can handle it. This reduces filesize by 769b   }
{ this program does not use EGOF!                                           }

{$I-}    { All IO-errors handled by the program }

Uses
  Dos;

Var
  F :File of Byte;
  B :Byte;


Function AddExt (FN:PathStr; Ext:ExtStr) :PathStr;
{ Add the extension [Ext] to [FN] if one is not already present }
Var
  Dir  :DirStr;
  Name :NameStr;
  CExt :ExtStr;
Begin
  FSplit (FExpand(FN),Dir,Name,CExt);
  If CExt = '' Then
    AddExt := Dir+Name+'.'+Ext
  Else
    AddExt := Dir+Name+CExt;
End;


Procedure Error (E:Byte);
{ Write error message and syntax and halt }
Begin
  WriteLn;
  Case E of
    1 : WriteLn ('Required parameter missing');
    2 : WriteLn ('File not found');
    3 : WriteLn ('Not a PCX file');
    4 : WriteLn ('No 256 colour palette found');
    5 : WriteLn ('IO error');
  End;
  WriteLn;
  WriteLn ('Syntax :');
  WriteLn ('  KillPal <file>');
  WriteLn;
  WriteLn ('Where:');
  WriteLn ('  file is the name of a PCX file to remove palette from');
  WriteLn;
  Halt;
End;

Begin
  If ParamStr(1)='' Then                   { Did we get a parameter ?    }
    Error(1);
  Assign (F,AddExt(ParamStr(1),'PCX'));
  ReSet (F);
  If IoResult <> 0 Then
    Error (2);

  Read (F,B);                              { Check for PCX sign          }
  If B<>$0A Then
    Error (3);

  Seek (F,FileSize(F)-769);                { Check 256 col. pal. flag    }
  Read (F,B);
  If B<>$0C Then
    Error (4);

  Seek (F,FileSize(F)-770);                { Remove the rest of the file }
  Truncate (F);
  If IoResult <> 0 Then
    Error (5);
  Close (F);

  WriteLn ('The file ',ParamStr(1), ' has been depaletted');
End.