Program MouseTest;
{
  Controls:

  Left button press :
    Freehand drawing
  Left button double-click :
    Fill box; Double-click, hold, drag to other corner and release.
  Right button press :
    Pick up colour under cursor.
  Right button double-click :
    Change palette;
  Left and right button pressed :
    Quit.
}

{$B-}

Uses
  EGOF,
  MouseU,
  FilterU,
  VgaU,
  VesaU,
  PalU,
  MemoryU,
  FractalU,
  CRT;

Const
  Picture  :Array[Mode320x200..Mode360x480] of String =
    ('FracV.pcx',
     'Frac1.pcx',
     'Frac2.pcx',
     'Frac3.pcx',
     'Frac4.pcx',
     'Frac5.pcx',
     'FracX.pcx',
     'FracY.pcx',
     '',
     '',
     '',
     'FracZ.pcx');

  Mode = Mode320x200;   { Try using Mode640x400 }

Var
  Scr     :EBitMapP;
  Spr     :SpriteO;
  Pal     :VgaPalO;
  MPoint  :SmallMemMapO;
  MScript :ScriptP;
  Mouse   :MouseO;

  Mandel  :MandelbrotO;
  MX,MY   :Word;

  Quit    :Boolean;
  XX,YY   :Word;
  CC      :Byte;


Procedure ECheck (Graphic:Boolean);
{ Chck for errors and if any are found display an error message and halt    }
{ Graphic tells us weather we are in graphics mode. If so we must change to }
{ text mode before destroying the RS object                                 }
Var
  EC :ShortInt;
Begin
  If IsEgofError Then Begin
    If Graphic Then
      Scr^.Done;
    EC := GetEgofError;

    { Write Error message }
    WriteLn ('Error #',EC,' : ',EgofErrorStr[EC],'.');
    WriteLn;

    { Write Error message in Icelandic }
    WriteLn ('Villa ',EC,'  : ',EgofErrorIce[EC],'.');
    Repeat Until ReadKey<>#0;
    Halt;
  End;
End;


Procedure DoSomething;
Var
  T   :Byte;
  X,Y :Word;
Begin
  X := Random (Scr^.XRes Div 2);
  Y := Random (Scr^.YRes Div 2);
  Spr.PutPix (X,Y, Random(256));

  Spr.PutPix (MX+Scr^.XRes Div 2,MY, Mandel.GetPix(MX,MY));
  Inc (MY);
  If MY>=Scr^.YRes Div 2 Then Begin
    MY := 0;
    Inc (MX);
    If MX>=Scr^.XRes Div 2 Then Begin
      MX := 0;
      Mandel.Zoom (0.5, 0.5, 1.44);
      Mandel.MaxI := Round(Mandel.MaxI*1.08);   { We need more iterations }
    End;
  End;

  If (MY And 15)=0 Then
    Spr.Line (Random(Scr^.XRes Div 2),Random(Scr^.YRes Div 2)+Scr^.YRes Div 2,
              Random(Scr^.XRes Div 2),Random(Scr^.YRes Div 2)+Scr^.YRes Div 2, Random(256));
End;


Procedure RandomCol (NoR :Byte);
{ Create [NoR] random colour-ranges, but keep colour 0 black }
Var
  R1,G1,B1,
  Rl,Gl,Bl,
  R,G,B  :Byte;
  Ra     :Byte;
Begin
  R1 := Random (63);
  G1 := Random (63);
  B1 := Random (63);

  Rl := R1;
  Gl := G1;
  Bl := B1;

  For Ra := 1 To NoR-1 Do Begin
    R := Random (63);
    G := Random (63);
    B := Random (63);

    Pal.Range (((Ra-1)*256 Div NoR), Rl,Gl,Bl, (Ra*256 Div NoR), R,G,B);

    Rl := R;
    Gl := G;
    Bl := B;
  End;

  Pal.Range (((NoR-1)*256 Div NoR), Rl,Gl,Bl, 255, R1,G1,B1);

  Pal.SetCol (0,0,0,0);
End;


Begin
  Randomize;
  CC := Random (256);
  Quit := False;

  Case Mode Of
    Mode320x200 :
      Scr := New (VgaP,Init);
    Mode320x240..Mode360x480 :
      Scr := New (VgaNsP,Init(Mode));
    Mode640x400..Mode1280x1024 :
      Scr := New (VesaP,Init(Mode));
  End;
  ECheck (False);
  Pal.Init;
  Scr^.ReadPcx (0,0, Picture[Mode],@Pal,nil);
  ECheck (True);

  MPoint.InitPcx ('Mouse.pcc',nil,nil);
  ECheck (True);
  MScript := MakeScriptT (@MPoint, 0,0, MPoint.XRes, MPoint.YRes, 255);
  Spr.Init (Scr, @MPoint, MScript);
  Mouse.Init (@Spr, MPoint.GetCenX,MPoint.GetCenY);
  ECheck (True);

  Spr.On;

  Mandel.Init (Scr^.XRes Div 2, Scr^.YRes Div 2, 128);
  Mandel.SetPos (-1.4796629362739300, 0.0009341553491329, 0.5);
  Mandel.SetPixRatio (Scr^.XRes/Scr^.YRes * 3/4);
  MX := 0;
  MY := 0;

  Repeat
    DoSomething;
    While Mouse.NewEvent Do Begin      { Handle all the events in the que }
      Mouse.NextEvent;                 { Get the next event from the que  }

      With Mouse.Event^ Do Begin
        Case What of
          MeDown :
            Begin
              If (BStat And $3)=$3 Then    { Press both left and right }
                Quit := True;
              If Who=0 Then         { Press left button }
                Spr.PutPix (WhereX,WhereY, CC)
              Else                  { Press right/middle button }
                CC := Spr.GetPix (WhereX,WhereY);
            End;

          MeDrag :
            If Who=0 Then         { Drag with left button pressed }
              Spr.Line (XX,YY, WhereX,WhereY, CC);

          MeDouble :
            If Who=0 Then Begin   { Double-click with left button }
              Repeat
                Repeat
                  DoSomething;
                Until Mouse.NewEvent;  { Wait for something to happen }
                Mouse.NextEvent;
              Until (Mouse.Event^.What=MeUp) And (Mouse.Event^.Who=0);  { Until the left button is released? }
              Spr.FBox (XX,YY, Mouse.Event^.WhereX,Mouse.Event^.WhereY, CC);
            End
            Else Begin            { Double-click with right/middle button }
              RandomCol (Random(8)+2);
            End;
        End;
      End;

      XX := Mouse.Event^.WhereX;
      YY := Mouse.Event^.WhereY;
    End;
  Until Quit Or (KeyPressed And (ReadKey<>#0));

  Mouse.Done;
  MPoint.Done;
  KillScript (MScript);
  Spr.Done;
  Dispose (Scr,Done);
End.