program EgaSavDm;

(* ------------------------------------------------------------
   Demonstrates the use of the EGA Graphics screen_saving and
   screen_restoring routines from the EGASave.pas unit.
   Last update: 5/5/88 by John Sieraski;
   ------------------------------------------------------------ *)
uses crt,
      graph,
      EGASave;
var
  Graphdriver : integer;
  GraphMode   : integer;
  GraphError  : integer;
  Buffer      : EGABuffer; { Used to store an EGA screen image.}
  ch          : char;

procedure RandomBars;
{ Draw random bars on the screen }
const
  MaxBars = 300;
var
  MaxWidth  : integer;
  MaxHeight : integer;
  Color     : word;
  Count     : integer;
begin
  maxwidth  := 639;
  maxheight := 349;
  for count := 1 to maxbars do
  begin
    color := random(16);
    setcolor(color);
    setfillstyle(random(closedotfill)+1,color);
    bar3d(random(maxwidth),random(maxheight),
        random(maxwidth),random(maxheight),0,topoff);
  end;
  setcolor(getmaxcolor);
  rectangle(0,0,getmaxX,getmaxY);
  settextjustify(centertext,centertext);
  outtextXY(getmaxX div 2,getmaxY div 2,'Press any key...');
end;

begin
  graphdriver := EGA;
  graphmode := EGAHi;
  initgraph(graphdriver,graphmode,'f:\u');
  grapherror := graphresult;
  if grapherror <> grOK then
  begin
    writeln('Graphics ERROR: ',Grapherrormsg(grapherror));
    write('Press any key to halt...');
    ch := readkey;
    HALT(1);
  end;
  AllocateBuffer(Buffer); { allocate screen buffer on the heap }
  RandomBars;
  SaveEGAScreen(Buffer);
  ch := readkey;
  cleardevice;
  settextjustify(centertext,centertext);
  outtextXY(getmaxX div 2,getmaxY div 2, 'Screen saved, press any key to '+
                                         'restore it from the buffer');
  ch := readkey;
  RestoreEGAScreen(buffer);
  ch := readkey;
  closegraph;
end.