program EgaTest;

uses
  Crt, Graph, EgaMouse;

var
   grDriver, grMode: integer;
   X,Y,Stat       : Word;
   Mouse: boolean;

procedure TestMouse;

var
  Ch               : Char;
  X,Y,Stat,I       : Word;
  S1, S2, S3       : String;

begin {TestMouse}

  if not Mouse_Installed then
  begin
    OutTextXY(10,10,'Mouse not installed');  { if mouse hardware and }
    Halt                                     { software not found, then abort }
  end;


  OutTextXY(240,15,'EGAMouse Demo');

  Rectangle(130,70,270,160);
  SetFillStyle(1,blue);
  FloodFill(131,71,white);
  OutTextXY(160,55,'Hour Glass');

  Rectangle(320,70,460,160);
  SetFillStyle(1,green);
  FloodFill(321,71,white);
  OutTextXY(340,55,'Pointing Hand');

  Rectangle(130,190,270,280);
  SetFillStyle(1,red);
  FloodFill(131,191,white);
  OutTextXY(165,175,'Check Mark');

  Rectangle(320,190,460,280);
  SetFillStyle(1,magenta);
  FloodFill(321,191,white);
  OutTextXY(337,175,'Diagonal Cross');

  TextColor(white);

  GotoXY(28,23);
  Write('Mouse is at');
  GotoXY(26,24);
  Write('Button(s) Pressed:');

  SetMousePosition(300,175);    { Set Mouse position to screen center }
  ShowMouse;                    { Display standard Mouse cursor }


  repeat  { Loop until key pressed }

    Stat := MousePosition(X,Y);
    if ((X>130) and (X<270)) and ((Y>70) and (Y<160)) then
       CursorShape(HourGlass)
    else if ((X>320) and (X<460)) and ((Y>70) and (Y<160)) then
       CursorShape(PointingHand)
    else if ((X>130) and (X<270)) and ((Y>190) and (Y<280)) then
       CursorShape(CheckMark)
    else if ((X>320) and (X<460)) and ((Y>190) and (Y<280)) then
       CursorShape(DiagCross)
    else
       CursorShape(Standard);

    Str(X,S1);
    Str(Y,S2);
    Str(Stat,S3);

    GotoXY(40,23);
    Write(S1+', '+S2:8);    { write Mouse X and Y coordinates }

    GotoXY(45,24);
    case Stat of
       0: S3 := 'none ';
       1: S3 := 'left ';
       2: S3 := 'right';
       3: S3 := 'both '
    end;
    Write(S3);              { write button status }

  until KeyPressed;

end; {TestMouse}


begin {Main}

  DirectVideo := false;

  grDriver := EGA;
  grMode := EGAHi;                   { sets EGA 16 color 640 x 350 mode }
  InitGraph(grDriver, grMode, '');
  if GraphResult<> grOk then
  begin
     Writeln('Graphics init error: ', GraphErrorMsg(grDriver));
     Halt(1);                        { if error during graphics mode }
  end;                               { initialization then abort }

  TestMouse;

  CloseGraph;

  RestoreCrtMode;

end.
