program ed;

uses
  Crt,
  Minikit,
  O_Tbuf,
  EditWin;

var
  DOSScreen : TSavedScreenInfo;
  BottomLine,
  BottomLineText : string;
  TextBuf   : PTextBuffer;
  EdWin     : PEditWindow;
  ExitKey   : char;
  OK,
  UserQuits : boolean;

begin
  OK := SaveScreen (DOSScreen);                     { Save underlying screen }
  New (TextBuf, Init (3000));                       { 3000 line text buffer }
  New (EdWin, Init (8, 3, 72, 22,                   { edit window coords }
                    ' ED - Public Domain editor ',  { the header message }
                    TextBuf,                        { use this buffer }
                    EditOK ));                      { editor mode }

  UserQuits := false;                               { not done yet! }
  if ParamCount > 0 then
    EdWin^.SetFileName (ParamStr (1))
  else
    EdWin^.SetFileName ('');
  EdWin^.ShowWindow;                                { display the window }

  BottomLine := MakeString (65, ' ');                { show commands }
  BottomLineText :=
    'AltX:Quit F9:Open F10:Save ^T:Del word ^Y:Del line AltG:Reform';
  BottomLine := Merge (BottomLineText, BottomLine, 2);
  FastWrite (BottomLine, 23, 8, Status_Attr);

  repeat                                            { stay in loop ... }
    EdWin^.Process;                                 { edit text }
    ExitKey := EdWin^.GetExitKey;                   { get the key thay ended edit }

    case ExitKey of                                 { check it out }
      AltX : UserQuits := true;                     { AltX means we are done }
    end;
  until UserQuits;                                  { until we are done editing }

  TextBuf^.Done;                                    { dispose of text buffer }
  EdWin^.Done;                                      { dispose of editor }
  RestoreScreen (DOSScreen);                        { and restore screen }
end.
