Unit Mem;

{$C Preload Permanent}

{This unit implements an array and vector which can grow in size as required 
during the execution of the program. The number of observations (rows) is
almost unlimmited because of the use of list and a swapfile that is created
on disk. It's written with the object Orientated Filosofie in mind and 
requires Borland Pascal v7.0 (OOP-requirement) and runs in DOS Protected
Mode (Needs the DLL for the DPMI)

If anyone use this unit or makes desendents of the objects, I would greatly 
appreciate if they mention my name for writing this piece of source. If you
make your own version of this objects, I would appreciate it, if you send it
to me for further development of the unit.


Contact Adress :
    De Busscher Rudy
    Kerselarenstraat 39
    3071 Kortenberg Belgium

Details:
    Before using one of the described objects you need to call the function
    SwapFile_Init which returns True if the creation of a swapfile was 
    succesfull.
    Swapfile_Done should be called at the end of the program so that 
    everything is cleaned up properly.

    TDynArray implements an array with a fixed number of columns, maximum 100,
    and an unlimited number of rows (As long as there is enough space on the
    harddisk)

    Var
        Array : PDynArray;

    Usage : Before using the array, you have to initialise it by making
            an instance of the object
                    New(Array,Init);

            And when you are finished using the array, you deinitialise it
            by the statement :
                    Dispose(Array,Done);

            The two most important methods are the Put and Get method for
            accessing the array.
                    Array^.Put(X,Y,W);
                    W := Array^.Get(X,Y);
            With  Var W = Real; X,Y : Word;

            Put places the real W in the array on the place X,Y (X = Row,
            Y = Column). And Get retrieves the real at place X,Y.

            Y ranges from 0 to 99, X from 0..???

            If one use the get method with X and Y parameter which are greater
            than the greatest one you used with put, you get a run-time error
            203.

            Examples
                Suppose this code:
                    New(Array,Init);
                    W := Random(1);
                    Array^.Put(0,0,W);
                    Array^.Put(0,2,W);
                    Array^.Put(2,0,W);
                    Array^.Put(2,2,W);
                    W := Array^.Get(3,3); -> Runtime error 203
                    W := Array^.Get(1,1); -> Runtime Error 203
                    W := Array^.Get(0,1); -> Returns 0 in W
                        See the techincal reference for an explanation of
                        the last line.

            When you do not need the data in the array anymore, but you don't
            want to use the Destructor Done (Because you need an array in an
            other part of your program and want to keep the name), you can
            use the Clear method:
                Array^.Clear;

            It is strongly recomended using Clear or Done as soon as you 
            don't need the data or array anymore because of the rather strong
            memory requirements of the object.
    
    TDynFrame is a descendent of TDynArray. Besides the functionality of 
    TDynArray, it implements names for variables (Columns) and observation
    (Rows) and opne can assign a code (Char-type) to each variable.

    Usage: The methods Init, Done, Put, Get and Clear are used in the same 
           way as with TDynArray. The Put method is extended so that the first
           time you assign a value to a row it recevies the Observation name:
           Obsxxx (xxx is the row number)

           Procedure Put_VarNaam(Y : Word; T : String;C : Char);
            Sets the variable name of column Y to string Y to the variable 
            code to character C
           
           Procedure Put_ObsNaam(X : Word; T : String);
            Sets the observation name of row X to string T

           Function Get_VarNaam(Y : Word) : String;
            Retrieves the Variable name of column Y

           Function Get_ObsNaam(X : Word) : String;
            Retrieves the Observation name of row X

           Function Code(Y : Word) : Char;
            Retrieves the Code of variable (column) Y

    TDynArray2 is another descendent of TDynArray. If you want to use more
    than 100 columns, you can swap the X and Y when you call the Put and Get 
    method. But what if you want to allocate a matrix of 200 columns and 200
    rows? TDynArray2 can allocate a fixed numer of rows (ranging from 1 to ??
    , as long as there is enough memory) and unlimited number of columns.

    The only difference with TDynArray is that you have the precise the number
    of rows you want to use when you allocate the object.

    Example
        Var Array : PDynArray;

        New(Array,Init(300));
        Array^.Put(100,120,W); -> Ok, no error
        Array^.Put(310,120,W); -> No error shall be generated, but it is
                                  likely that another data shall be over-
                                  written.

    TDynVector implements a vector with unlimited observation. It is very
    symilar to TDynArray but the Put and Get methods only accepts the X
    parameter.

Technical documentation

    The implementation is based on small one-dimensional arrays with 50
    elements, which are combined in list for every variable / Column.

    The definition is :

        PObs = ^TObs;
        TObs = Record
            Id : Byte;
            Obs : Array[0..49] Of Real;
            Next : PObs;
        End;

        Id = Number that represent position. Id * 50 -> Starting row
        Obs = One dimensional array of values
        Next = Points to the a position in memory where another structure
              with data is placed. (Nil of it is the last one)

    When you supply an X to the Put methods, it checks of the corresponding
    Id (X Div 50) exists.
    If not, it creates the rows with that Id and fills them with zeros.

    Suppose Var Vect : PDynVect;
            Begin;
                New(Vect,Init);
                Vect^.Put(20,8); -> Creates vector observations 0..49 and
                                    puts at 20 the value 8.
                Vect^.Put(30,9); Puts in the same datastructure (Has also Id
                                 0) the value 9 on position 30
                Vect^.Put(101,7); -> Creates vector observations 100..149.
                                     The range 50..99 doesn't exist and 
                                     therefore
                Writeln(Vect^.Get(80)); Gives a runtime error but
                Writeln(Vect^.Get(15)); Gives zero because of the initial
                                        filling with zero.

    Before it creates the datastructure TObs, it checks if there is enough
    memory available. If not, it enlarges the Swapfile with 0.5 Mb.
}


Interface

Type
    PObs = ^TObs;
    TObs = Record
         Id : Byte;
         Obs : Array[0..49] Of Real;
         Next : PObs;
    End;

    PDynArray = ^TDynArray;
    TDynArray = Object
              Constructor Init;
              Procedure Put(X,Y : Word; W : Real); Virtual;
              Function Get(X,Y : Word) : Real;
              Procedure Clear;
              Destructor Done;
              Private
              Xmax,Ymax : Word;
              DynArray : Array[0..99] Of PObs;
              Function Check(Xg,Y : Word) : Boolean;
              Procedure Create(Xg,Y : Word); Virtual;
              Function Point_Blok(Xg,Y : Word) : PObs;
              Procedure Put_Waarde(Xg,Xgr,Y : Word; W : Real); Virtual;
              Function Get_Waarde(Xg,Xgr,Y : Word) : Real;
    End;

    PDynArray2 = ^TDynArray2;
    TDynArray2 = Object(TDynArray)
              Constructor Init(S : Word);
              Procedure Put(X,Y : Word; W : Real); Virtual;
              Function Get(X,Y : Word) : Real;
              Private
              Shift : Word;
    End;

    PDynVector = ^TDynVector;
    TDynVector = Object
                 Constructor Init;
                 Procedure Put(X: Word; W : Real);
                 Function Get(X : Word) : Real;
                 Procedure Clear;
                 Destructor Done;
                 Private
                 Xmax: Word;
                 DynVector : PObs;
                 Function Check(Xg : Word) : Boolean;
                 Procedure Create(Xg : Word);
                 Function Point_Blok(Xg : Word) : PObs;
                 Procedure Put_Waarde(Xg,Xgr : Word; W : Real); Virtual;
                 Function Get_Waarde(Xg,Xgr : Word) : Real;
    End;

    PObsNaam = ^TObsNaam;
    TObsNaam = Record
             Id : Byte;
             Obs : Array[0..49] Of String[20];
             Next : PObsNaam;
    End;

    PDynFrame = ^TdynFrame;
    TDynFrame = Object(TDYnArray)
              Constructor Init;
              Procedure Put(X,Y : Word; W : Real); Virtual;
              Procedure Put_VarNaam(Y : Word; T : String;C : Char);
              Procedure Put_ObsNaam(X : Word; T : String);
              Function Get_VarNaam(Y : Word) : String;
              Function Get_ObsNaam(X : Word) : String;
              Function Code(Y : Word) : Char;
              Destructor Done;
              Private
              Variabel : Array[0..99] Of String[20];
              VarCode : Array[0..99] Of Char;
              Obsnaam : PObsNaam;
              Function Check_Obs(Xg : Word) : Boolean;
              Procedure Create(Xg,Y : Word); Virtual;
              Function Point_ObsNaam(Xg : Word) : PObsNaam;
    End;

    Function SwapFile_Init : Boolean;

    Function SwapFile_Done : Boolean;

Const
     SwapFn = 'hicupp.$$$';

Implementation

Uses Crt;

const
  rtmOK          = $0;
  rtmNoMemory    = $1;
  rtmFileIOError = $22;
  Mega  : LongInt = 1024*1024;

Var
   SwapFileSize : Real;

function MemInitSwapFile(FileName: PChar; FileSize: Longint): Integer; Far;
         external 'RTM' index 35;
  {  Opens a swapfile of the specified size.  If a swapfile
     already exists, and the new size is larger, the swapfile
     will grow, otherwise the previous swap file parameters are
     used.

     Returns:   rtmOK           - Successful
                rtmNoMemory     - Not enough disk space
                rtmFileIOError  - Could not open/grow file
  }


function MemCloseSwapFile(var Delete: Integer): Integer; Far;
         external 'RTM' index 36;
  {  Closes the swapfile if it was created by the current task.
     If the value returned in "Delete" is non-zero, the swapfile
     was deleted.

     Returns:   rtmOK           - Successful
                rtmNoMemory     - Not enough physical memory to run
                                  without the swap file
                rtmFileIOError  - Could not close/delete the file
  }

Function SwapFile_Init;

Var
   C : Integer;

Begin
     C := MemInitSwapFile(SwapFn,0);
     If C <> RTMOk Then
        SwapFile_Init := False
     Else
         SwapFile_Init := True;
     SwapFileSize := 0;
End;

Function SwapFile_Done;

Var
   W,C : Integer;

Begin
     C := MemCloseSwapFile(W);
     If C <> RTMOk Then
        SwapFile_Done := False
     Else
         SwapFile_Done := True;
End;

Constructor TDynArray.Init;

Var
   i : Byte;

Begin
     Xmax := 0;
     YMax := 0;
     For i:= 0 To 99 Do
         DynArray[i] := Nil;
End;

Function TDynArray.Check;

Var
   Dummy : Pobs;

Begin
     Check := True;
     If DynArray[Y] = Nil Then
        Check := False
     Else
     Begin
          Check := False;
          Dummy := DynArray[Y];
          While Dummy <> Nil Do
          Begin
               If Dummy^.Id = Xg Then
               Begin
                    Dummy := Nil;
                    Check := True;
               End
               Else
                   Dummy := Dummy^.Next;
          End;
     End;
End;

Procedure TDynArray.Create;

Var
   Dummy : PObs;
   C, i : Integer;

Begin
     If MemAvail<500000 Then
     Begin
          SwapFileSize := SwapFileSize + 0.5;
          C := MemInitSwapFile(SwapFn,Round(SwapFileSize*Mega));
          If C <> RTMOk Then
          Begin
               Clrscr;
               RunError(203);
          End;
     End;
     New(Dummy);
     Dummy^.Id := Xg;
     For i:= 0 To 49 Do
         Dummy^.Obs[i] := 0;
     Dummy^.Next := DynArray[Y];
     DynArray[Y] := Dummy;
End;

Function TDynArray.Point_Blok;

Var
   Fl : Boolean;
   Dummy : Pobs;

Begin
     Fl := True;
     Dummy := DynArray[Y];
     While Fl Do
     Begin
          If Dummy^.Id = Xg Then
             Fl := False
          Else
              Dummy := Dummy^.Next;
     End;
     Point_Blok := Dummy;
End;

Procedure TDynArray.Put_Waarde;

Var
   Dummy : PObs;

Begin
     Dummy := Point_Blok(Xg,Y);
     Dummy^.Obs[Xgr] := W;
End;

Procedure TDynArray.Put;

Var
   Xg,Xgr : Word;

Begin
     If Y>99 Then
        RunError(201);
     Xg := X Div 50;
     Xgr := X Mod 50;
     If Not Check(Xg,Y) Then
        Create(Xg,Y);
     Put_Waarde(Xg,Xgr,Y,W);
     If Y>YMax Then YMax := Y;
     If X>XMax Then XMax := X;
End;

Function TDynArray.Get_Waarde;

Var
   Dummy : PObs;

Begin
     Dummy := Point_Blok(Xg,Y);
     get_Waarde := Dummy^.Obs[Xgr];
End;

Function TDynArray.Get;

Var
   Xg,Xgr : Word;

Begin
     If (X>Xmax) Or (Y>Ymax) Then
        RunError(201);
     Xg := X Div 50;
     Xgr := X Mod 50;
     If Not Check(Xg,Y) Then
        Get := 0
     Else
         Get := Get_Waarde(Xg,Xgr,Y);
End;

Procedure TDynArray.Clear;

Var
   Dummy : PObs;
   i : Byte;

Begin
     For i:= 0 To 99 Do
     Begin
          While DynArray[i] <> Nil Do
          Begin
               Dummy := DynArray[i];
               DynArray[i] := Dummy^.Next;
               Dispose(Dummy);
          End;
     End;
End;

Destructor TDynArray.Done;

Begin
     Clear;
End;

Constructor TDynArray2.Init;

Begin
     Inherited Init;
     Shift := S;
End;

Procedure TDynArray2.Put;

Var
   Xn,Yn : Longint;

Begin
     Xn := (Y Div 100)*Shift + X;
     Yn := Y Mod 100;
     Inherited Put(Xn,Yn,W);
End;

Function TDynArray2.Get;

Var
   Xn,Yn : Longint;

Begin
     Xn := (Y Div 100)*Shift + X;
     Yn := Y Mod 100;
     Get := Inherited Get(Xn,Yn);
End;

Constructor TDynFrame.Init;

Var
   i : Byte;

Begin
     Inherited Init;
     For i:= 0 To 99 Do
         Variabel[i] := '';
     ObsNaam := Nil;
End;

Function TDynFrame.Check_Obs;

Var
   Dummy : PObsNaam;

Begin
     Check_Obs := False;
     Dummy := ObsNaam;
     While Dummy <> Nil Do
     Begin
          If Dummy^.Id = Xg Then
          Begin
               Dummy := Nil;
               Check_Obs := True;
          End
          Else
              Dummy := Dummy^.Next;
     End;
End;

Procedure TDynFrame.Create;

Var
   Dummy1 : PObs;
   C, i : Integer;
   Dummy2 : PObsNaam;

Begin
     If MemAvail<500000 Then
     Begin
          SwapFileSize := SwapFileSize + 0.5;
          C := MemInitSwapFile(SwapFn,Round(SwapFileSize*Mega));
          If C <> RTMOk Then
          Begin
               Clrscr;
               RunError(203);
          End;
     End;
     New(Dummy1);
     Dummy1^.Id := Xg;
     For i:= 0 To 49 Do
         Dummy1^.Obs[i] := 0;
     Dummy1^.Next := DynArray[Y];
     DynArray[Y] := Dummy1;
     If Not Check_Obs(Xg) Then
     Begin
          New(Dummy2);
          Dummy2^.Id := Xg;
          For i:= 0 To 49 Do
              Dummy2^.Obs[i] := '';
          Dummy2^.Next := ObsNaam;
          Obsnaam := Dummy2;
     End;
End;

Function TDynFrame.Point_ObsNaam;

Var
   Fl : Boolean;
   Dummy : PObsNaam;
   Dummy2 : PObsNaam;
   i : Byte;

Begin
     If Not Check_Obs(Xg) Then
     Begin
          New(Dummy2);
          Dummy2^.Id := Xg;
          For i:= 0 To 49 Do
              Dummy2^.Obs[i] := '';
          Dummy2^.Next := ObsNaam;
          Obsnaam := Dummy2;
     End;
     Fl := True;
     Dummy := ObsNaam;
     While Fl Do
     Begin
          If Dummy^.Id = Xg Then
             Fl := False
          Else
              Dummy := Dummy^.Next;
     End;
     Point_ObsNaam := Dummy;
End;

Procedure TDynFrame.Put;

Var
   Xg,Xgr : Word;
   Dummy : PObsNaam;
   T : String;

Begin
     Inherited Put(X,Y,W);
     Xg := X Div 50;
     Xgr := X Mod 50;
     Dummy := Point_ObsNaam(Xg);
     If Dummy^.Obs[Xgr]='' Then
     Begin
          Str(X,T); T := 'OBS'+T;
          Dummy^.Obs[Xgr]:= T;
     End;
End;

Procedure TDynFrame.Put_VarNaam;

Begin
     Variabel[Y] := T;
     VarCode[Y] := C;
End;

Procedure TDynFrame.Put_ObsNaam;

Var
   Xg,Xgr : Word;
   Dummy : PObsNaam;

Begin
     Xg := X Div 50;
     Xgr := X Mod 50;
     Dummy := Point_ObsNaam(Xg);
     Dummy^.Obs[Xgr]:= T;
End;

Function TDynFrame.Get_VarNaam;

Begin
     get_VarNaam := Variabel[Y];
End;

Function TDynFrame.Get_ObsNaam;

Var
   Xg,Xgr : Word;
   Dummy : PObsNaam;

Begin
     Xg := X Div 50;
     Xgr := X Mod 50;
     Dummy := Point_ObsNaam(Xg);
     get_ObsNaam := Dummy^.Obs[Xgr];
End;

Function TDynFrame.Code;

Begin
     Code := VarCode[Y];                        0
End;

Destructor TDynFrame.Done;

Var
   Dummy : PObsNaam;

Begin
     While ObsNaam <> Nil Do
     Begin
          Dummy := ObsNaam;
          Obsnaam := Dummy^.Next;
          Dispose(Dummy);
     End;
     Inherited Done;
End;

Constructor TDynVector.Init;

Var
   i : Byte;

Begin
     Xmax := 0;
     DynVector := Nil;
End;

Function TDynVector.Check;

Var
   Dummy : Pobs;

Begin
     Check := True;
     Check := False;
     Dummy := DynVector;
     While Dummy <> Nil Do
     Begin
          If Dummy^.Id = Xg Then
          Begin
               Dummy := Nil;
               Check := True;
          End
          Else
              Dummy := Dummy^.Next;
     End;
End;

Procedure TDynVector.Create;

Var
   Dummy : PObs;
   C, i : Integer;

Begin
     If MemAvail<500000 Then
     Begin
          SwapFileSize := SwapFileSize + 0.5;
          C := MemInitSwapFile(SwapFn,Round(SwapFileSize*Mega));
          If C <> RTMOk Then
          Begin
               Clrscr;
               RunError(203);
          End;
     End;
     New(Dummy);
     Dummy^.Id := Xg;
     For i:= 0 To 49 Do
         Dummy^.Obs[i] := 0;
     Dummy^.Next := DynVector;
     DynVector := Dummy;
End;

Function TDynVector.Point_Blok;

Var
   Fl : Boolean;
   Dummy : Pobs;

Begin
     Fl := True;
     Dummy := DynVector;
     While Fl Do
     Begin
          If Dummy^.Id = Xg Then
             Fl := False
          Else
              Dummy := Dummy^.Next;
     End;
     Point_Blok := Dummy;
End;

Procedure TDynVector.Put_Waarde;

Var
   Dummy : PObs;

Begin
     Dummy := Point_Blok(Xg);
     Dummy^.Obs[Xgr] := W;
End;

Procedure TDynVector.Put;

Var
   Xg,Xgr : Word;

Begin
     Xg := X Div 50;
     Xgr := X Mod 50;
     If Not Check(Xg) Then
        Create(Xg);
     Put_Waarde(Xg,Xgr,W);
     If X>XMax Then XMax := X;
End;

Function TDynVector.Get_Waarde;

Var
   Dummy : PObs;

Begin
     Dummy := Point_Blok(Xg);
     get_Waarde := Dummy^.Obs[Xgr];
End;

Function TDynVector.Get;

Var
   Xg,Xgr : Word;

Begin
     If X>Xmax Then
        RunError(201);
     Xg := X Div 50;
     Xgr := X Mod 50;
     If Not Check(Xg) Then
        Get := 0
     Else
         Get := Get_Waarde(Xg,Xgr);
End;

Procedure TDynVector.Clear;

Var
   Dummy : PObs;
   i : Byte;

Begin
     While DynVector <> Nil Do
     Begin
          Dummy := DynVector;
          DynVector := Dummy^.Next;
          Dispose(Dummy);
     End;
End;

Destructor TDynVector.Done;

Begin
     Clear;
End;

End.
