Unit Drives;

   {Supplement to Turbo Professional DOS unit.

    Requires DOS 3.x or higher to function.

    Documentation in DRIVES.DOC.

    Written by Richard M. Kellogg Jr.

    Last updated on 1/28/90.}


interface

uses
   Dos;

function DriveIsRemoveable(Drive : char) : boolean;
   {-Returns True if the specified drive uses removeable media.}

function DriveIsFixed(Drive : char) : boolean;
   {-Returns True if the specified drive uses fixed media.}

function DriveIsAbsent(Drive : char) : boolean;
   {-Returns True if the specified drive is invalid.}

function NumberOfFloppies : integer;
   {-Returns the number of floppy drives installed on the system.}

implementation

{===================================================================}

type
   DriveType = (Absent, Floppy, Fixed);

function DrivePrimitive(DriveNumber : integer) : DriveType;

var
   Regs : Registers;

begin
Regs.BX := DriveNumber;                 {Check for drive is changeable}
Regs.AX := $4408;                       {media using MS-DOS IOCTL sub-}
MsDos(Regs);                            {function number 8.           }

if (Regs.Flags and $1) = 0 then         {Function call was successful }
   if (Regs.AL = 0) then                {so therefore the drive exists}
      DrivePrimitive := Floppy
   else
      DrivePrimitive := Fixed
else
   DrivePrimitive := Absent;            {Function call failed so drive}
                                        {is missing                   }
end; {of DrivePrimitive}

{------------------------------------------------------}

function DriveIsRemoveable(Drive : char) : boolean;
   begin
   Drive := UpCase(Drive);
   DriveIsRemoveable := (DrivePrimitive(Ord(Drive)-64) = Floppy);
   end;

{------------------------------------------------------}

function DriveIsFixed(Drive : char) : boolean;
   begin
   Drive := UpCase(Drive);
   DriveIsFixed := (DrivePrimitive(Ord(Drive)-64) = Fixed);
   end;

{------------------------------------------------------}

function DriveIsAbsent(Drive : char) : boolean;
   begin
   Drive := UpCase(Drive);
   DriveIsAbsent := (DrivePrimitive(Ord(Drive)-64) = Absent);
   end;

{------------------------------------------------------}

function NumberOfFloppies : Integer;

   var
      Regs : Registers;

   begin
   Intr($11,Regs);

   if ((Regs.AL and $01) = 1) then
      NumberOfFloppies := (Regs.AL Shr 6) + 1
   else
      NumberOfFloppies := 0;
   end;

end. {of Drives Unit}
