#define MAXPARAM 6
#define VersionID "SCRIPT1"

//various record types in the script file, used also to identify the type
//of control
enum recType {Dlg, Button, SText, CText, InputL, Labl, Histry, ILong, CheckB,
              RadioB, MultiCB, ListB, Memo, ScrollB, Done = -1};

//various type of validators--not useful in C++ yet
enum valType {Picture, Range, Filter, StringLookup, none = -1};

//the base struct.  Overridden by objects that read the script file and
//again by objects that write source.  Contains data that is common to
//the dialog and all controls.  Read operations will be accomplished by
//the constructor, write operations by extensions to the methods.
struct  ViewObj {
    char *BaseObj,    //base object, like TInputLine
         *Obj;        //actual class name, like TMyInputLine
    int X1, Y1, X2, Y2,   //the TRect
        DefOptns, Optns,  //default and actual options
        DefEvMsk, EvMsk,  //default and actual eventMask
        HCtx,             //helpCtx value
        Grow;             //growMode
    char *Param[MAXPARAM];   //possible 6 extra parameters
    char *HelpCtxSym,        // like hcNoContext
         *FieldName,         //name you entered for dataRec fieldname
         *VarName;           //name you entered for variable name or 'control'

    ViewObj();
    virtual void writeCode() {};
    virtual void writeFields() {};
    virtual void writeVars() {};
    };

//the following objects will have their constructors defined to read the
//script file.  They also contain fields special to the control type.
struct DialogObj : ViewObj {    //the dialog itself
   ushort Palette, WinFlags;
   char *DlgFuncName,         //like makeDialog
        *KeyString,           //ID string used when storing resource
        *Title;               //dialog title
   DialogObj();
   };

struct ButtonObj : ViewObj {
   char *CommandName,        //like cmOK
        *ButtonText;         //like O~k~
   ushort CommandValue,      //value for Command
          Flags;
   ButtonObj();
   };

struct  StaticTextObj : ViewObj {
   ushort Attrib;
   char *Text;
   StaticTextObj();
   };

struct  ColoredTextObj : StaticTextObj {
   ColoredTextObj() : StaticTextObj() {};
   };

      // validator objects for TInputLine not used in C++ but which may be
      //present in ascii file.
      struct ValidatorObj {
          ValidatorObj() {};
          virtual void writeCode() {};
          };
      struct  PictureValidatorObj : ValidatorObj {
	 int AutoFill;
	 char *PictureString;
         PictureValidatorObj();
	 };
      struct  RangeValidatorObj : ValidatorObj {
	 long int LowLim, UpLim;
	 ushort Transfer;
         RangeValidatorObj();
	 };
      struct StringLookupValidatorObj : ValidatorObj {
         char *List;
         StringLookupValidatorObj();
         };
      struct FilterValidatorObj : ValidatorObj {
         char *CharSet;
         long ActualCharSet[8];  //represents actual character set
         FilterValidatorObj();
         };

struct  InputLineObj : ViewObj {
   ushort StringLeng;       //AMaxLen parameter
   char *ValPtrName;        //Class name of validator (not used in C++
   ValidatorObj* val;
   InputLineObj();
   };

struct  InputLongObj : ViewObj {
   char *LongLabelText;      //Text of label, used for error reporting
   ushort LongStrLeng;       //AMaxLen parameter
   long int LLim, ULim;
   ushort ILOptions;
   InputLongObj();
   };

struct   LabelObj : ViewObj {
   char *LabelText,
        *LinkName;     //variable name of control to which label is linked
   LabelObj();
   };

struct  HistoryObj : ViewObj  {
   ushort HistoryID;
   char *HistoryLink;  //variable name of control to which history is linked
   HistoryObj();
   };

struct  ClusterObj : ViewObj   {   //basis for RadioButtons, CheckBoxes, MultiCheckBoxes
   ushort Items;
   long int Mask;     //enableMask, not used in C++
   TStringCollection *LabelColl;   //collection of label names
   ClusterObj();
   };
struct  RadioButtonObj : ClusterObj {
   RadioButtonObj() : ClusterObj() {};
   };
struct  CheckBoxObj : ClusterObj {
   CheckBoxObj() : ClusterObj() {};
   };
struct  MultiCheckBoxObj : ClusterObj {  //not useful in C++ yet
   ushort MCBFlags;
   int SelRange;
   char *States;
   MultiCheckBoxObj();
   };

struct  ListBoxObj : ViewObj {
   ushort Columns;
   char *ScrollBar;    //variable name of attached scrollbar
   ListBoxObj();
   };
struct  MemoObj : ViewObj {
   char *TextFieldName;
   ushort BufSize;
   char *VScroll, *HScroll;
   MemoObj();
   };
struct ScrollBarObj : ViewObj {
   ScrollBarObj() : ViewObj() {};
   };

extern TNSCollection *ScriptColl;  //all controls read are stored in this collection
extern ViewObj* Dialog;   //the dialog itself is stored here
extern Boolean present[ScrollB + 1];  //tells which Kinds are present
extern TStringCollection *classCollection;  //a collection of all the Class names

ViewObj* getKind(recType Kind);
void readScriptFile(char* scriptName);
void checkMemory();
