/*
 A demo program for reading C++ TDialog resources.  This program
 registers all the objects (__link()) which are standard in Dialog Design.  If
 you use other controls, be sure to register them .  Failure to do so may
 result in a crash.

 Note:  This program must be compiled and linked with the same compiler and
 library use to create the resource file to be read.

 When compiling with BC3.1, #define TV1.  When compiling with BC4.02,
 #define TV2.
*/

#define Uses_TApplication
#define Uses_TKeys
#define Uses_TRect
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_TScrollBar
#define Uses_TDialog
#define Uses_TButton
#define Uses_TLabel
#define Uses_TInputLine
#define Uses_TListBox
#define Uses_TStringCollection
#define Uses_TResourceFile
#define Uses_fpstream
#define Uses_TFileDialog
#define Uses_MsgBox

#if defined (TV2)
#   include <tvision/tv.h>
#elif defined (TV1)
#   include <tv.h>
#else
#   error TV1 or TV2 must be defined
#endif

#include <stdlib.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
__link(RView);
__link(RDialog);
__link(RResourceCollection);
__link(RButton);
__link(RCluster);
__link(RCheckBoxes);
__link(RRadioButtons);
__link(RLabel);
__link(RStaticText);
__link(RScrollBar);
__link(RInputLine);
__link(RHistory);
__link(RListBox);
__link(RMemo);
__link(RColoredText);
__link(RInputLong);
__link(RCombo)
__link(RStringCollection)
__link(RNoCaseStringCollection)
#ifdef TV2
__link (RRangeValidator);
__link (RFilterValidator);
__link (RStringLookupValidator);
__link (RPXPictureValidator);
__link (RMultiCheckBoxes);
#endif

const
  cmTry = 150;

#ifdef TV1
struct TListBoxRec  //already defined in TV2
{
    TCollection* items;
    ushort selection;
};
#endif

class TMyApp : public TApplication
{
public:
    TMyApp();
    static TStatusLine *initStatusLine(TRect r);
    virtual void outOfMemory(void);
    ushort getFileName(void);
    TDialog* MakeDialog(void);
    virtual void handleEvent(TEvent& event);

    char filename[MAXPATH];
};

TMyApp::TMyApp() :
    TProgInit( &TMyApp::initStatusLine,
          &TMyApp::initMenuBar,
          &TMyApp::initDeskTop
        )
{
}

void TMyApp::outOfMemory()
{
 messageBox("Insufficient memory for this operation", mfOKButton);
}

TStatusLine *TMyApp::initStatusLine( TRect r )
{
    r.a.y = r.b.y - 1;     // move top to 1 line above bottom
    return new TStatusLine( r,
      *new TStatusDef(0, 0xFFFF) +
      *new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit) +
#ifdef TV2
      *new TStatusItem("~F9~ Load TV2 Resource File", kbF9, cmTry)
#else
      *new TStatusItem("~F9~ Load TV1 Resource File", kbF9, cmTry)
#endif
    );
}

ushort TMyApp::getFileName(void)
{
  TFileDialog* FD;
  unsigned command;
  int done;
  struct ffblk fblk;

 do
  {FD = new TFileDialog("*.REZ", "Select resource file", "~N~ame", fdOKButton, 10);
   if (validView(FD))
     {
     command = deskTop->execView(FD);
     if ((command == cmFileOpen) || (command == cmOK))
       {
       FD->getFileName(filename);
       destroy(FD);
       if (!strchr(filename, '.'))
         strcat(filename, ".REZ");
       }
     else
       {destroy(FD);
        return cmCancel;}
     }
   else return cmCancel;
   done = !findfirst(filename, &fblk, 0);
   if (!done)
     messageBox(mfOKButton, "Can't find %s", filename);
   }
while (!done);
return command;
}

TDialog* makeDialog(void)
{
TView *control;
TDialog* dlg = new TDialog(TRect(16, 3, 61, 19), "Resource Selection");
if (!dlg) return 0;

control = new TScrollBar(TRect(27, 3, 28, 14));
dlg->insert(control);

control = new TListBox(TRect(5, 3, 27, 14), 1, (TScrollBar*)control);
dlg->insert(control);

  dlg->insert(new TLabel(TRect(4, 2, 14, 3), "~R~esources", control));

control = new TButton(TRect(31, 3, 42, 5), "~D~isplay", cmOK, bfDefault);
dlg->insert(control);

control = new TButton(TRect(31, 6, 42, 8), "Cancel", cmCancel, bfNormal);
dlg->insert(control);

dlg->selectNext(False);
return dlg;
}

void TMyApp::handleEvent(TEvent& event)
{
 TListBoxRec Listbox;

 TApplication::handleEvent(event);
 if( event.what == evCommand && event.message.command == cmTry )
   {ushort command = getFileName();
    if (command != cmCancel)
      {fpstream* strm = new fpstream(filename, ios::in|ios::binary);
       TResourceFile* rsrc = new TResourceFile( strm );
       if (rsrc->count() == 0)
          messageBox(mfOKButton, "%s is not a Resource file", filename);
       else
         {TDialog* dialog = makeDialog(); //this dialog allows selecting resource ID's
          if (validView(dialog))
            {Listbox.items = new TStringCollection (5,10);
             //put ID's in list for listbox
             for (int i = 0; i <= rsrc->count()-1; i++)
               Listbox.items->insert(newStr(rsrc->keyAt(i)));
             Listbox.selection = 0;
             dialog->setData(&Listbox);
             do {
                command = deskTop->execView(dialog);
                dialog->getData(&Listbox);  //get selection
                if (command == cmOK)
                  {char* s = (char*)Listbox.items->at(Listbox.selection);
                   TDialog* dlg = (TDialog*) rsrc->get(s); //get the TDialog resource
                   if (validView(dlg))
                     {deskTop->execView(dlg); //show it
                      destroy( dlg);}
                  }
                }
             while (command == cmOK);
             destroy(dialog);
             destroy(Listbox.items);
            }
         }
       destroy(rsrc);
      }
    clearEvent(event);
   }
}

int main()
{
    TMyApp myApp;
    myApp.run();
    return 0;
}
