{$B-} {- : short circuit boolean evaluation: on }
{$D-} {+ : debug & lineinfo: on }
{$F-} {- : force far calls: off }
{$I-} {+ : I/O error checking: on }
{$L+} {+ : link buffer: on }
{$N-} {- : 8087 code: off }
{$R-} {- : numeric range checking: off }
{$S-} {+ : stack overflow checking: on }
{$T-} {- : map file generation: off }
{$V-} {+ : var-string checking: on }
{$M 16384,0,0} { memory in bytes: stacksize,heapmin,heapmax }

program DiskInfo;
{
Author:   Michael BoRowiec [72067,3025]
Written:  November 14, 1987
Requires: Turbo Pascal 4.0 -or- greater
}
uses DOS;

type
  String5 = string[5]; { for function HexString }
var
  DriveCount : word;   { "for" control variable }

{}function HexString(Number: Word): String5; { outputs string5: 0000h }

{--}function HexChar(Number: Word): Char;
    begin
      if Number < 10 then
        HexChar:= char(Number + 48)
      else
        HexChar:= char(Number + 55);
{--}end; { function HexChar }

  var
    S: String5;
  begin
    S     := '';
    S     := HexChar((Number shr 1) div 2048);
    Number:= (((Number shr 1) mod 2048) shl 1) + (Number and 1);
    S     := S + HexChar(Number div 256);
    Number:= Number mod 256;
    S     := S + HexChar(Number div 16);
    Number:= Number mod 16;
    S     := S + HexChar(Number);
    HexString:= S + 'h';
{}end; { function HexString }

{}function GetDriveData(Drive             :word;  { DOS service 01Ch }
                    var SectorsPerCluster :byte;
                    var BytesPerSector,
                        ClustersPerDrive  :word;
                    var DriveType         :byte) : boolean;

  var Regs        : Registers; { typed in DOS unit }
      BytePointer : ^byte;     { byte pointer }

  begin                             { could use "with", but I don't like it }
    Regs.AX:= $1C00;                { Get Drive Data function }
    Regs.DX:= Drive;                { Loads DL with drive 1=A, 2=B, etc. }
    msdos(Regs);
    if Regs.AL = $FF then           { invalid drive }
      begin
        GetDriveData:= false;
        exit;
      end;
    GetDriveData     := true;
    SectorsPerCluster:= Regs.AL;              { byte }
    BytesPerSector   := Regs.CX;              { word }
    ClustersPerDrive := Regs.DX;              { word }
    BytePointer      := ptr(Regs.DS,Regs.BX); { pointer to Drive Type byte }
    DriveType        := BytePointer^;         { dereference pointer }
{}end; { function GetDriveData }

{}procedure WriteDiskData(Drive : word);

  var
    B1,                     { dummy }
    DriveType  : byte;      { returned from DOS function 01Ch }
    DriveID    : char;      { drive letter }
    W1,W2      : word;      { dummy }
    TypeString : string;
    DiskBytes,              { total bytes on disk }
    FreeBytes  : longint;   { free  bytes on disk }

  begin { WriteDiskData }
    if GetDriveData(Drive,B1,W1,W2,DriveType) then  { valid drive }
      begin
        DriveID  := chr(Drive + (ord('A') - 1));
        DiskBytes:= DiskSize(Drive);  { function in DOS unit }
        FreeBytes:= DiskFree(Drive);  { function in DOS unit }
        case DriveType of             { 3.5" types unknown }
          $FF : TypeString:= 'DSDD, 8 sector';
          $FE : TypeString:= 'SSDD, 8 sector';
          $FD : TypeString:= 'DSDD, 9 sector';
          $FC : TypeString:= 'SSDD, 9 sector';
          $F9 : TypeString:= 'DSQD,15 sector';
          $F8 : TypeString:= 'Fixed Disk    ';
          $CD : TypeString:= 'EXCEPTION TYPE'
        else
                TypeString:= HexString(DriveType) + ' Unknown ';
        end; { case }
        writeln(DriveID,': ',TypeString,' ',
                DiskBytes:9,' total bytes. ',FreeBytes:9,' bytes free.');
      end;
{}end; { procedure WriteDiskData }

(*((((((((((((((((((((   O U T E R   B L O C K   ))))))))))))))))))))*)

BEGIN
  writeln('DiskInfo v1.0: (c)1987 by BoRowiec Ltd.');
  writeln;
  for DriveCount:= (ord('A') - 64) to (ord('Z') - 64) do { drives A - Z }
    WriteDiskData(DriveCount);
END.
