{      program: DISAP2
       disappearing input-line and radiobuttons

       solution by august quint
}
 
{$X+}
program DisappearingInputLineDemo;

uses
    Objects,Drivers,Views,Dialogs,App;
const
    cmPortLPT1               = 40000;
    cmPortLPT2               = 40001;
    cmPortCOM1               = 40002;
    cmPortCOM2               = 40003;
    cmPortCOM3               = 40004;
    cmPortCOM4               = 40005;
    cmPortFile               = 40006;
var
    PrinterPortCommand : array [0..6] of word;


type
    PDemo = ^TDemo;
    TDemo = object (TApplication)
       constructor Init;
    end;

(*  InputLine, receiving evBroadcast-messages: *)
    PInputLineReceiver = ^TInputLineReceiver;
    TInputLineReceiver = object(TInputLine)
        constructor Init( var Bounds : TRect; AMaxlen : integer );
        procedure   HandleEvent( var Event : TEvent ); virtual;
    end;

(*  RadioButtons, receiving evBroadcast-messages: *)
    PRadioButtonsReceiver = ^TRadioButtonsReceiver;
    TRadioButtonsReceiver = object(TRadioButtons)
      constructor Init( var Bounds : TRect; AStrings : PSItem );
      procedure   HandleEvent( var Event : TEvent ); virtual;
    end;

(*  RadioButtons, sending evBroadcast-messages: *)
    PRadioButtonsSender = ^TRadioButtonsSender;
    TRadioButtonsSender = object(TRadioButtons)
      procedure   HandleEvent( var Event : TEvent ); virtual;
    end;


constructor TDemo.Init;
var
    Dialog        : PDialog;
    SpecInputLine : PInputLineReceiver;
    Rectangle     : TRect;
    Button        : PButton;
    RadioButtons  : PRadioButtons;
    RBSender      : PRadioButtonsSender;
    RBReceiver    : PRadioButtonsReceiver;
    Text          : PStaticText;
    LabelText     : PLabel;
    RetCode       : Word;
begin
(*  Init the array with the appropriate commands: *)
    PrinterPortCommand[0] := cmPortLPT1;
    PrinterPortCommand[1] := cmPortLPT2;
    PrinterPortCommand[2] := cmPortCOM1;
    PrinterPortCommand[3] := cmPortCOM2;
    PrinterPortCommand[4] := cmPortCOM3;
    PrinterPortCommand[5] := cmPortCOM4;
    PrinterPortCommand[6] := cmPortFile;
    TApplication.Init;

    Rectangle.Assign(2,1,77,20);
    Dialog := New(PDialog,Init(Rectangle,'enter printer-data'));

    Rectangle.Assign(3,9,34,10);
    Text := New(PStaticText,Init(Rectangle,'printer connected via COMx:'));
    Dialog^.Insert(Text);

    Rectangle.Assign(3,2,27,5);
    RadioButtons := New(PRadioButtons,Init(Rectangle,
                        NewSItem('IBM-GraphicPrinter',
                        NewSItem('HP LaserJet II/III',
                        NewSItem('Epson FX80',nil)))));
    Rectangle.Assign(2,1,20,2);
    LabelText := New(PLabel,Init(Rectangle,'type of printer:',RadioButtons));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RadioButtons);

    Rectangle.Assign(33,2,45,9);
    RBSender:= New(PRadioButtonsSender,Init(Rectangle,
                   NewSItem('LPT 1',
                   NewSItem('LPT 2',
                   NewSItem('COM 1',
                   NewSItem('COM 2',
                   NewSItem('COM 3',
                   NewSItem('COM 4',
                   NewSItem('File:',nil)))))))));
    Rectangle.Assign(31,1,47,2);
    LabelText := New(PLabel,Init(Rectangle,'outputting via:',RBSender));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RBSender);

    Rectangle.Assign(45,8,72,9);
    SpecInputLine := New(PInputLineReceiver,Init(Rectangle,64));
    Rectangle.Assign(45,7,69,8);
    LabelText := New(PLabel,Init(Rectangle,'if output in file:',SpecInputLine));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(SpecInputLine);

    Rectangle.Assign(13,10,73,11);
    RBReceiver:= New(PRadioButtonsReceiver,Init(Rectangle,
                     NewSItem(' 300',
                     NewSItem(' 600',
                     NewSItem('1200',
                     NewSItem('2400',
                     NewSItem('4800',
                     NewSItem('9600',nil))))))));
    RBReceiver^.Value := 5;
    RBReceiver^.Sel := 5;
    Rectangle.Assign(2,10,13,11);
    LabelText := New(PLabel,Init(Rectangle,'baud:',RBReceiver));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RBReceiver);

    Rectangle.Assign(19,11,45,12);
    RBReceiver:= New(PRadioButtonsReceiver,Init(Rectangle,
                     NewSItem('8 bits  ',
                     NewSItem('7 bits',nil))));
    Rectangle.Assign(2,11,9,12);
    LabelText := New(PLabel,Init(Rectangle,'data:',RBReceiver));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RBReceiver);

    Rectangle.Assign(19,12,45,13);
    RBReceiver:= New(PRadioButtonsReceiver,Init(Rectangle,
                     NewSItem('1 bit   ',
                     NewSItem('2 bits',nil))));
    Rectangle.Assign(2,12,8,13);
    LabelText := New(PLabel,Init(Rectangle,'stop:',RBReceiver));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RBReceiver);

    Rectangle.Assign(19,13,43,14);
    RBReceiver:= New(PRadioButtonsReceiver,Init(Rectangle,
                     NewSItem('odd     ',
                     NewSItem('even',nil))));
    Rectangle.Assign(2,13,10,14);
    LabelText := New(PLabel,Init(Rectangle,'parity:',RBReceiver));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RBReceiver);

    Rectangle.Assign(19,14,42,15);
    RBReceiver:= New(PRadioButtonsReceiver,Init(Rectangle,
                     NewSItem('XON/XOFF',
                     NewSItem('DTR',nil))));
    Rectangle.Assign(2,14,16,15);
    LabelText := New(PLabel,Init(Rectangle,'flow control:',RBReceiver));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RBReceiver);

    Rectangle.Assign(13,16,21,18);
    Button := New(PButton,Init(Rectangle,'O~K~',cmOK,bfDefault));
    Button^.AmDefault := True;
    Dialog^.Insert(Button);

    Rectangle.Assign(48,16,60,18);
    Button := New(PButton,Init(Rectangle,'Cancel',cmCancel,bfNormal));
    Dialog^.Insert(Button);

(*  inform window of state of selection, assuming first entry selected *)
    Message(Dialog, evBroadcast, PrinterPortCommand[0], nil);
    Dialog^.SelectNext(False);
    RetCode := DeskTop^.ExecView(Dialog);

    Dispose(Dialog,Done);
end;

(*                                                                    *)
(*                                                                    *)
(*       the InputLine, receiving evBroadcast-messages                *)
(*                                                                    *)
(*       create object: allow receiving of evBroadcast-messages       *)
(*                                                                    *)
constructor TInputLineReceiver.Init( var Bounds : TRect; AMaxlen : integer );
begin
    TInputLine.Init( Bounds, AMaxlen);
    eventMask := eventMask or evBroadcast;
end;

(*                                                                    *)
(*       received evBroadcast-message: handling                       *)
(*                                                                    *)
procedure TInputLineReceiver.HandleEvent( var Event : TEvent );
begin
    if Event.What=evBroadcast then
    begin
        case Event.Command of
           cmPortLPT1,
           cmPortLPT2,
           cmPortCOM1,
           cmPortCOM2,
           cmPortCOM3,
           cmPortCOM4 :  Hide;
           cmPortFile :  Show;
        end;
    end;
    TInputLine.HandleEvent( Event );
end;

(*                                                                    *)
(*       the RadioButtons, receiving evBroadcast-messages             *)
(*                                                                    *)
(*       create object: allow receiving of evBroadcast-messages       *)
(*                                                                    *)
constructor TRadioButtonsReceiver.Init( var Bounds : TRect; AStrings : PSItem );
begin
    TRadioButtons.Init( Bounds, AStrings);
    eventMask := eventMask or evBroadcast;
end;
(*                                                                    *)
(*       received evBroadcast-message: handling                       *)
(*                                                                    *)
procedure TRadioButtonsReceiver.HandleEvent( var Event : TEvent );
begin
    if Event.What=evBroadcast then
    begin
        case Event.Command of
           cmPortLPT1,
           cmPortLPT2,
           cmPortFile : Hide;
           cmPortCOM1,
           cmPortCOM2,
           cmPortCOM3,
           cmPortCOM4 :  Show;
        end;
    end;
    TRadioButtons.HandleEvent( Event );
end;

(*                                                                    *)
(*       the RadioButtons, sending evBroadcast-messages               *)
(*                                                                    *)
procedure TRadioButtonsSender.HandleEvent( var Event : TEvent );
var
    OldValue : integer;
begin
    OldValue := Value;
    TRadioButtons.HandleEvent( Event );
    if OldValue<>Value then
    begin
(*      send message: inform of no. selected                          *)
        Message( Owner, evBroadcast, PrinterPortCommand[Value], @Self);
(*      active object: stays at RadioButton                           *)
        Select;
    end;
end;


var
    Demo: TDemo;

begin
    Demo.Init;
    Demo.Run;
    Demo.Done;
end.
