PROGRAM DDS;

 {DDS shows a disk drive summary of all active drives, including bytes/sector,
  sectors/cluster, number of clusters, bytes capacity, bytes available,
  and working directory.  SUBSTituted "virtual" drives are not shown.

  (C) Copyright 1989, Earl F. Glynn, Overland Park, KS.  Compuserve 73257,3527.
  All Rights Reserved.  Version 1.0, July 1989.  This Turbo Pascal 5.5 PROGRAM
  may be freely distributed for non-commercial use.

  Information about the Disk Parameter Block and what I have termed the
  "Drive Array" was found in the public domain program SYSID.PAS by
  Steve Grant, Long Beach, CA.  I prefer to use RECORDs and pointers to
  access this information instead of the MEM and MEMW Turbo Pascal "arrays".}

  USES DOS;  {AnyFile,DOSerror,FindFirst,FindNext,Intr,SearchRec}

  TYPE
    DiskParameterBlockPointer = ^DiskParameterBlock;
    DiskParameterBlock      =
      RECORD                                        { offset }
        misc1               :  BYTE;                {  0 $00 }
        driveunit           :  BYTE;                {  1 $01 }
        BytesPerSector      :  WORD;                {  2 $02 }
        SectorsPerCluster   :  BYTE;                {  4 $04 }
        ClusterToSectorShift:  BYTE;                {  5 $05 }
        ReservedSectors     :  WORD;                {  6 $06 }
        FATs                :  BYTE;                {  8 $08 }
        RootDirectoryEntries:  WORD;                {  9 $09 }
        FirstDataSector     :  WORD;                { 11 $0B }
        Clusters            :  WORD;                { 13 $0D }
        SectorsPerFAT       :  BYTE;                { 15 $0F }
        RootDirectorySector :  WORD;                { 16 $10 }
        DeviceHeader        :  pointer;             { 18 $12 }
        MediaType           :  BYTE;                { 22 $16 }
        Valid               :  BYTE;                { 23 $17 }
        NextDPB             :  pointer              { 24 $18 }
      END;

    DriveArrayPointer   = ^DriveArray;
    DriveArray          =
      RECORD
        DefaultDirectory:  ARRAY[1..69] OF CHAR;   {ASCIIZ string}
        DPB             :  DiskParameterBlockPointer;
      END;

    DOSListOfLists      =
      RECORD                                        { offset  }
        FirstMCBSegment :  WORD;                    { -2 -$02 }
        misc1           :  ARRAY[1..16] OF BYTE;    {  0  $00 }
        MaxBytesPerBlock:  WORD;                    { 16  $10 }
        misc2           :  ARRAY[1..4]  OF BYTE;    { 18  $12 }
        BaseDA          :  DriveArrayPointer;       { 22  $16 }
        misc3           :  ARRAY[1..7]  OF BYTE;    { 26  $1A }
        LastDrive       :  BYTE                     { 33  $21 }
      END;

  VAR
    c      :  CHAR;
    DA     :  DriveArrayPointer;
    DirInfo:  SearchRec;
    DPB    :  DiskParameterBlockPointer;
    drive  :  WORD;
    entries:  WORD;
    i      :  WORD;
    LoL    :  ^DOSListOfLists;
    r      :  Registers;

BEGIN
  r.AH := $52;
  Intr ($21,r);                        {Undocumented DOS function}
  LoL := Ptr(r.ES,r.BX-2);             {DOS List of Lists - 2}
  DA := LoL^.BaseDA;
  WRITELN ('Disk Drive Summary (Version 1, July 1989)');
  WRITELN (' ':48,'Root Dir');
  WRITELN ('       Bytes/                 B y t e s          Entries        Working');
  WRITELN ('Drive  Cluster Clusters  Capacity  Available   Max  Current    Directory');
  WRITELN ('-----  ------- --------  --------- ---------  ----- -------  -------------');
  drive := 1;
  REPEAT
    DPB := DA^.DPB;
    IF   DPB^.MediaType > 0
    THEN BEGIN
      WRITE (' ':2,DA^.DefaultDirectory[1]);
      WITH DPB^ DO BEGIN
        r.AH := $36;    {Do this first in case floppy disk was changed.}
        r.DL := drive;  {Capacity and Available will be from same disk.}
        Intr ($21,r);
        WRITE   (BytesPerSector*(SectorsPerCluster+1):10,Clusters - 1:9,
                 LONGINT(BytesPerSector)*(SectorsPerCluster+1)*
                 (Clusters-1):12);
        IF   r.AX = $FFFF
        THEN WRITE ('offline':10)
        ELSE WRITE (LONGINT(r.BX)*r.AX*r.CX:10);
        WRITE (RootDirectoryEntries:6);
        IF   r.AX = $FFFF
        THEN WRITE ('offline':9)
        ELSE BEGIN
          entries := 0;   {count root directory entries}
          FindFirst (DA^.DefaultDirectory[1]+':\*.*',AnyFile,DirInfo);
          WHILE DOSerror = 0 DO BEGIN
            INC (entries);
            FindNext (DirInfo)
          END;
          WRITE (entries:7,' ':2)
        END
      END;
      WRITE ('  ');
      i := 1;
      c := DA^.DefaultDirectory[i];
      WHILE c > #$00 DO BEGIN
        WRITE (c);
        INC (i);
        c := DA^.DefaultDirectory[i]
      END;
      WRITELN
    END;
    INC (drive);
    DA := Ptr(Seg(DA^), Ofs(DA^)+$51)
  UNTIL (Seg(DPB^.NextDPB^) = $FFFF) OR (drive > LoL^.LastDrive);
  IF   drive <= LoL^.LastDrive
  THEN WRITELN (' ':2,CHR(ORD('A')+LoL^.LastDrive-1),' is LASTDRIVE')
END {DDS}.
