PROGRAM CURVFIT;

{ The coefficients are found by minimizing the sum of the square
  of the difference between the given data and the prediction.
  The equation AG=B is solved by matrix inversion. An augmented
  matrix A is created for matrix inversion by attaching B to the
  last column of A. The Gaussian elimination method reduces the
  original A to a unit matrix as the solution.

  This program was originally written in BASIC and presented in
  MACHINE DESIGN Sept 6, 1984. It was rewritten in PASCAL by
  Tim Kelly Jan 26, 1986.
}
Var
  A          : array[0..25,0..26] of real;
  C          : array[0..25,0..26] of real;
  X,Y,W,Z    : array[0..25] of real;
  N          : integer; { number of data points}
  L          : integer; { order of polynomial}
  M,R,I,J,K  : integer;
  S          : real;
  Dum        : Char;

{.........................................................................}

Procedure MATRIX;

BEGIN
  For K:=1 to M do
  Begin
    S:=A[K,K];
    For I:=K to R do A[K,I]:=A[K,I]/S;
    For J:=1 to M do
    If J <> K then
    begin
      S:=A[J,K];
      For I:=K to R do A[J,I]:=A[J,I]-A[K,I]*S;
    end;
  End;
END;

{.........................................................................}

Procedure ON(y,x: Integer);
BEGIN
  GotoXY(x,y);
  Write('[]',^H);
END;

{.........................................................................}

Procedure ONL(y,x: Integer);
BEGIN
  GotoXY(x,y);
  Write('--',^H);
END;

{.........................................................................}

Procedure OFF(x,y: Integer);
BEGIN
  GotoXY(x,y);
  Write(' ',^H);
END;

{.........................................................................}

Procedure BOX;
Var
  i,j : Integer;
BEGIN
  For i:=1 to 39 do
  begin
    j:=i*2;
    ON(1,j); ONL(7,j);ON(24,j);
  end;
  For i:=1 to 24 do
  begin
    ON(i,2); ON(i,78);
  end;
END;

{.........................................................................}
 Procedure OUTPUTCK;
 BEGIN
   Write(X[i]:10,' ',y[i]:10,' ',w[i]:10,' ',z[i]:10,' ');
 END;

{=========================================================================}

BEGIN
  clrscr; BOX;
  gotoXY(30,3);write('GENERAL ORDER POLYNOMIAL');
  gotoXY(33,4);write('CURVE FIT PROGRAM');
  gotoXY(8,6);write('Number of data points :? ');Read(N);
  gotoXY(47,6);write('Order of Polynomial :? ');Read(L);

  M:=L+1;  R:=L+2;

  For I:=1 to N do
  Begin
    gotoXY(35,12);Write('X(',I,')=? ');read(X[i]);
    gotoXY(35,13);Write('Y(',I,')=? ');read(Y[i]);
    For J:=35 to 60 do OFF(j,12);
    For J:=35 to 60 do OFF(j,13);
  End;

  For J:=1 to N do C[J,1]:=1;

  For I:=2 to M do
  Begin
    For J:=1 to N do C[J,I]:=C[J,I-1]*X[J];
  End;

  For I:= 1 to M do
  Begin
    For J:=1 to M do
    begin
      A[I,J]:=0.;
      For K:=1 to N do A[I,J]:=A[I,J]+C[K,I]*C[K,J];
    end;
  End;

  For I:=1 to M do
  Begin
    A[I,R]:=0;
    For K:=1 to N do A[I,R]:=A[I,R]+C[K,I]*Y[K];
  End;

  Matrix;

  For I:=1 to N do
  Begin
    W[I]:=0;
    For J:=1 to M do
    begin      { evaluate polynomial }
      If J=1 then S:=1 else
      begin
        S:=X[I];
        If J>2 then For K:=3 to J do S:=S* X[I];
      end;
      W[I]:=W[I]+A[J,R]* S;
    end;
    Z[I]:=Abs( W[I]-Y[I] ) / Y[I] *100.;
  End;

  gotoXY(5,8);Write(' Coefficients :');
  gotoXY(5,10);For I:=0 to L do write('    X^',I:1,'    ');
  gotoXY(5,11);For I:=1 to M do Write(A[I,R]:10,' ');

  gotoXY(17,13);Write('     X          Y       Y(calc)   %(error)');
  gotoXY(17,14);For I:=1 to 44 do Write('-');
  For I:=1 to N do
  begin
    If I < 9
    then begin
      gotoXY(17,14+I); OUTPUTCK end
    else begin
      If I = 9
      then begin
         gotoXY(17,23);Write('Hit any return key to continue');Read(Dum);
         For J:=17 to 70 do For K:=15 to 23 do OFF(J,K) ;
         gotoXY(17,6+I);OUTPUTCK end
      else begin
      gotoXY(17,6+I);OUTPUTCK; end;
    end;
  end;
  GotoXY(4,22);Read(dum);ClrScr;
END.

