{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokePolygon ( xc, yc : integer ; { center }
                            r, n : word ; { radius and number of sides }
                              ta : single ) ; { rotation angle (rad) }

     { PolyRAF - draw regular polygon using rotation angle }
     {           method and fixed point arithmetic         }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   da               : single ;  { step angle }
   icosda,isinda    : longint ; { step angle functions B16 }
   ir               : longint ; { scaled radius B6 }
   icosta,isinta    : longint ; { rotation angle functions B16 }
   is               : integer ; { loop control }
   it,ix,iy         : longint ; { coordinate variables B6 }
   ix0,iy0,ix1,iy1  : integer ; { display variables B0 }

begin
                                { constraint test }
   if (r > 0) and (r < 512) and (n > 2) then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step angle and functions }
      da := 2.0 * Pi / n ;
      icosda := Round(cos(da) * 65536) ;
      isinda := Round(sin(da) * 65536) ;
                                { scaled radius }
      ir := r shl 6 ;
                                { rotation functions }
      icosta := Round(cos(ta) * 65536) ;
      isinta := Round(sin(ta) * 65536) ;

      ix := RoundScaleB16(ir * icosta) ;
      iy := -RoundScaleB16(ir * isinta) ;
      ix0 := RoundScaleB6(ix) ;
      iy0 := RoundScaleB6(LongHi(iy*iar)) ;
      MoveTo(xc+ix0,yc+iy0) ;
                                { polygon }
      for is := 1 to n-1 do begin
                                { rotate coordinates }
         it := RoundScaleB16(ix * icosda - iy * isinda) ;
         iy := RoundScaleB16(ix * isinda + iy * icosda) ;
         ix := it ;
                                { apply aspect ratio }
         ix1 := RoundScaleB6(ix) ;
         iy1 := RoundScaleB6(LongHi(iy*iar)) ;
         LineTo(xc+ix1,yc+iy1) ;

      end ;
                                { closure }
      LineTo(xc+ix0,yc+iy0)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
