{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeParabola ( xf, yf : integer ; { focus }
                                p : word ; { parameter }
                               ta : single ) ; { rotation angle (rad) }

     { ParaRA - draw parabola using rotation of coordinates }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   ar               : single ;  { aspect ratio }
   costa,sinta,acosta,asinta : single ; { rotation angle functions }
   xx,yx            : single ;  { coordinate limits }
   r,rx,t           : single ;  { polar radius and limit }
   x1,y1,x2,y2      : single ;  { coordinate variables }
   a,cosa,sina      : single ;  { polar angle and functions }
   da,cosda,sinda   : single ;  { step angle and functions }
   ix0,iy0,ix1,iy1,ix2,iy2,ix3,iy3 : integer ; { display variables }

begin
                                { ignore rectilinear parabola }
   if p > 0 then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      ar := ixar/iyar ;
                                { coordinate variables with }
                                { aspect and reflection     }
      cosa := 1.0 ;
      sina := 0.0 ;
      costa := cos(ta) ;
      sinta := sin(ta) ;
      acosta := ar * costa ;
      asinta := ar * sinta ;
                                { starting point }
      r := p/2 ;
      ix0 := xf + Round(r * costa) ;
      iy0 := yf - Round(r * asinta) ;
      ix2 := ix0 ;
      iy2 := iy0 ;
                                { coordinate limits }
      if xf > 0 then
         if xf > GetMaxX + 1 then
            xx := xf
         else
            if xf > GetMaxX div 2 then
               xx := xf
            else
               xx := GetMaxX - xf
      else
         xx := abs(xf) + GetMaxX + 1 ;

      if yf > 0 then
         if yf > GetMaxY + 1 then
            yx := yf
         else
            if yf > GetMaxY div 2 then
               yx := yf
            else
               yx := GetMaxY - yf
      else
         yx := abs(yf) + GetMaxY + 1 ;
                                { step angle and functions }
      rx := sqrt(sqr(xx) + sqr(yx)) ;
      da := 2.0 * sqrt(1.0/rx) ;
      cosda := cos(da) ;
      sinda := sin(da) ;

      while r < rx do begin
                                { polar angle functions }
         t := cosa * cosda - sina * sinda ;
         sina := sina * cosda + cosa * sinda ;
         cosa := t ;
                                { polar radius }
         r := p/(1.0 + cosa) ;
                                { rotation terms }
         x1 := r * cosa * costa ;
         x2 := r * sina * sinta ;
         y1 := r * sina * acosta ;
         y2 := r * cosa * asinta ;
                                { display coordinates }
         ix1 := xf + Round(x1-x2) ;
         iy1 := yf - Round(y1+y2) ;
         ix3 := xf + Round(x1+x2) ;
         iy3 := yf + Round(y1-y2) ;
                                { draw chords }
         Line(ix0,iy0,ix1,iy1) ;
         Line(ix2,iy2,ix3,iy3) ;
                                { ladder down }
         ix0 := ix1 ;  iy0 := iy1 ;
         ix2 := ix3 ;  iy2 := iy3

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
