{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeParabola ( xf, yf : integer ; { focus }
                                p : word ; { parameter }
                               ta : single ) ; { rotation angle (rad) }

     { ParaMBR - draw parabola using modified Bresenham with }
     {           rotation and aspect correction              }

const
   s = 16.0 ;

var
   Color            : word ;    { default color }
   costa,costa2     : single ;  { rotation angle functions }
   sinta,sinta2     : single ;  {            "             }
   px,py            : single ;  { aspect variables }
   pxx,pxy,pyy      : single ;  {         "        }
   x0,y0            : single ;  { extremum point, float }
   ix0,iy0          : integer ; {        "      , fixed }
   ix,iy            : integer ; { coordinate variables }
   ixx,iyx          : integer ; { coordinate limits }
   ie,iex,iey       : longint ; { error variables }
   idex,idey        : longint ; { error offsets }
   idex0,idey0      : longint ; {       "      , initial }
   idexx,idexy      : longint ; { error increments }
   ideyx,ideyy      : longint ; {        "         }

begin
                                { ignore rectilinear parabola }
   if p > 0 then begin

      Color := GetColor ;
                                { scaling parameters }
      px := 3 * GetMaxY ;
      py := 2 * GetMaxX ;
      if px > py then begin
         py := s * py / px ;
         px := s
      end
      else begin
         px := s * px / py ;
         py := s
      end ;
                                { rotation angle functions }
      costa := cos(ta) ;
      costa2 := sqr(costa) ;
      sinta := sin(ta) ;
      sinta2 := sqr(sinta) ;

      pxx := sqr(px)*sinta2 ;
      pxy := px*py*sinta*costa ;
      pyy := sqr(py)*costa2 ;
                                { error increments }
      idexx := Round(2.0*pxx) ;
      idexy := Round(2.0*pxy) ;
      ideyx := idexy ;
      ideyy := Round(2.0*pyy) ;
                                { coordinate limits }
      if xf > 0 then
         if xf > GetMaxX + 1 then
            ixx := xf
         else
            if xf > GetMaxX div 2 then
               ixx := xf
            else
               ixx := GetMaxX - xf
      else
         ixx := abs(xf) + GetMaxX + 1 ;

      if yf > 0 then
         if yf > GetMaxY + 1 then
            iyx := yf
         else
            if yf > GetMaxY div 2 then
               iyx := yf
            else
               iyx := GetMaxY - yf
      else
         iyx := abs(yf) + GetMaxY + 1 ;
                                { step in y }
      if abs(costa) > abs(sinta) then begin
                                { extremum point }
         x0 := p/2/costa ;
         y0 := -p/2/py*px*sinta/costa2 ;
         ix0 := Round(x0) ;
         iy0 := Round(y0) ;
         idex0 := Round((2*x0+1)*pxx - 2*y0*pxy + 2*p*sqr(px)*costa) ;
         idey0 := Round((2*y0+1)*pyy - 2*x0*pxy + 2*p*py*px*sinta) ;
                                { starting point }
         ix := ix0 ;
         iy := iy0 ;
         ie := 0 ;
                                { extremum point }
         PutPixel(xf+ix,yf-iy,Color) ;
                                { open leftwards }
         if costa >= 0.0 then begin

            idex := -idex0 + idexx ;
            idey := idey0 ;
                                { extremum to dx = dy }
            while (-idex > idey) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Inc(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Dec(ix) ;
                  Inc(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { dx = dy to dy = 0 }
            while (-idex > 0) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Dec(ix) ;
               Inc(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Inc(iy) ;
                  Inc(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;

            idey := -idey + ideyy ;
                                { dy = 0 to asymptote }
            while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Dec(ix) ;
               Dec(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Dec(iy) ;
                  Dec(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { reinitialize }
            ix := ix0 ;
            iy := iy0 ;
            ie := 0 ;

            idex := -idex0 + idexx ;
            idey := -idey0 + ideyy ;
                                { extremum to dx = dy }
            while (-idex > idey) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Dec(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Dec(ix) ;
                  Dec(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { dx = dy to dy = 0 }
            while (-idex > 0) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Dec(ix) ;
               Dec(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Dec(iy) ;
                  Dec(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;

            idey := -idey + ideyy ;
                                { dy = 0 to asymptote }
            while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Dec(ix) ;
               Inc(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Inc(iy) ;
                  Inc(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end
         end
                                { open rightwards }
         else begin

            idex := idex0 ;
            idey := idey0 ;
                                { extremum to dx = dy }
            while (-idex > idey) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Dec(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Inc(ix) ;
                  Dec(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { dx = dy to dy = 0 }
            while (-idex > 0) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Inc(ix) ;
               Dec(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Inc(iy) ;
                  Dec(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;

            idey := -idey + ideyy ;
                                { dy = 0 to asymptote }
            while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Inc(ix) ;
               Inc(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Dec(iy) ;
                  Inc(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { reinitialize }
            ix := ix0 ;
            iy := iy0 ;
            ie := 0 ;

            idex := idex0 ;
            idey := -idey0 + ideyy ;
                                { extremum to dx = dy }
            while (-idex > idey) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Inc(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Inc(ix) ;
                  Inc(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { dx = dy to dy = 0 }
            while (-idex > 0) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Inc(ix) ;
               Inc(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Dec(iy) ;
                  Inc(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;

            idey := -idey + ideyy ;
                                { dx = 0 to asymptote }
            while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Inc(ix) ;
               Dec(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Inc(iy) ;
                  Dec(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end
         end
      end
                                { step in x }
      else begin

         x0 := -p/2.0*costa/sinta2 ;
         y0 := p/2.0/py*px/sinta ;
         ix0 := Round(x0) ;
         iy0 := Round(y0) ;
         idex0 := Round((2*x0+1)*pxx - 2*y0*pxy + 2*p*sqr(px)*costa) ;
         idey0 := Round((2*y0+1)*pyy - 2*x0*pxy + 2*p*py*px*sinta) ;
                                { starting point }
         ix := ix0 ;
         iy := iy0 ;
         ie := 0 ;
                                { extremum point }
         PutPixel(xf+ix,yf-iy,Color) ;
                                { open upwards }
         if sinta >= 0.0 then begin

            idex := idex0 ;
            idey := -idey0 + ideyy ;
                                { extremum to dx = dy }
            while (-idey > idex) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Inc(ix) ;
               Inc(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Dec(iy) ;
                  Inc(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { dx = dy to dx = 0 }
            while (-idey > 0) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Inc(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Inc(ix) ;
                  Inc(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;

            idex := -idex + idexx ;
                                { dx = 0 to asymptote }
            while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Dec(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idey,ideyx) ;
                  Dec(ix) ;
                  Dec(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { reinitialize }
            ix := ix0 ;
            iy := iy0 ;
            ie := 0 ;

            idex := -idex0 + idexx ;
            idey := -idey0 + ideyy ;
                                { extremum to dx = dy }
            while (-idey > idex) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Dec(ix) ;
               Dec(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Dec(iy) ;
                  Dec(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { dx = dy to dx = 0 }
            while (-idey > 0) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Dec(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Dec(ix) ;
                  Dec(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;

            idex := -idex + idexx ;
                                { dx = 0 to asymptote }
            while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Inc(idex,ideyx) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Inc(ix) ;
                  Inc(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end
         end
                                { open downwards }
         else begin

            idex := idex0 ;
            idey := idey0 ;
                                { extremum to dx = dy }
            while (-idey > idex) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Inc(ix) ;
               Dec(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Inc(iy) ;
                  Dec(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { dx = dy to dx = 0 }
            while (-idey > 0) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Dec(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Inc(ix) ;
                  Dec(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;

            idex := -idex + idexx ;
                                { dx = 0 to asymptote }
            while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Inc(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Dec(ix) ;
                  Inc(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { reinitialize }
            ix := ix0 ;
            iy := iy0 ;
            ie := 0 ;

            idex := -idex0 + idexx ;
            idey := idey0 ;
                                { extremum to dx = dy }
            while (-idey > idex) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idex) ;
               Inc(idex,idexx) ;
               Dec(ix) ;
               Inc(idey,ideyx) ;
               iey := ie + idey ;
               if abs(ie) > abs(iey) then begin
                  Inc(idey,ideyy) ;
                  Inc(iy) ;
                  Inc(idex,idexy) ;
                  ie := iey
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;
                                { dx = dy to dx = 0 }
            while (-idey > 0) and
                    (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Inc(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Dec(ix) ;
                  Inc(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end ;

            idex := -idex + idexx ;
                                { dx = 0 to asymptote }
            while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

               Inc(ie,idey) ;
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Dec(idex,idexy) ;
               iex := ie + idex ;
               if abs(ie) > abs(iex) then begin
                  Inc(idex,idexx) ;
                  Inc(ix) ;
                  Dec(idey,ideyx) ;
                  ie := iex
               end ;

               PutPixel(xf+ix,yf-iy,Color)

            end
         end
      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
