{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeParabola ( xf, yf : integer ; { focus }
                                p : word ; { parameter }
                               ta : single ) ; { rotation angle (rad) }

     { ParaMB - draw parabola using modified Bresenham }

var
   Color            : word ;    { default color }
   px,py            : single ;  { aspect variables }
   x0,y0            : single ;  { starting point }
   ix,iy            : integer ; { coordinate variables }
   ixx,iyx          : integer ; { coordinate limits }
   ie,iex,iey       : longint ; { error variables }
   idex,idey        : longint ; { error offsets }
   idexx,ideyy      : longint ; { error increments }

begin
                                { ignore rectilinear parabola }
   if p > 0 then begin

      Color := GetColor ;
                                { coordinate limits }
      if xf > 0 then
         if xf > GetMaxX + 1 then
            ixx := xf
         else
            if xf > GetMaxX div 2 then
               ixx := xf
            else
               ixx := GetMaxX - xf
      else
         ixx := abs(xf) + GetMaxX + 1 ;

      if yf > 0 then
         if yf > GetMaxY + 1 then
            iyx := yf
         else
            if yf > GetMaxY div 2 then
               iyx := yf
            else
               iyx := GetMaxY - yf
      else
         iyx := abs(yf) + GetMaxY + 1 ;
                                { error and offset control }
      px := 3 * GetMaxY ;
      py := 2 * GetMaxX ;
                                { scaling parameters }
      if px > py then begin
         py := py / px ;
         px := 1.0
      end
      else begin
         px := px / py ;
         py := 1.0
      end ;
                                { starting point }
      x0 := p/2 ;
      y0 := 0.0 ;

      idex := -Round(2.0 * p * sqr(px)) ;
      idey := Round((2.0*y0+1.0) * sqr(py)) ;

      idexx := 0 ;
      ideyy := Round(2.0 * sqr(py)) ;

      ix := Round(x0) ;
      iy := Round(y0) ;
      ie := 0 ;
                                { vertex point }
      PutPixel(xf+ix,yf,Color) ;
                                { vertex to px = py }
      while (idey < -idex) and (-ix < ixx) and (iy < iyx) do begin

         Inc(ie,idey) ;
         Inc(idey,ideyy) ;
         Inc(iy) ;
         iex := ie + idex ;
         if abs(ie) > abs(iex) then begin
            ie := iex ;
            Inc(idex,idexx) ;
            Dec(ix)
         end ;

         PutPixel(xf+ix,yf+iy,Color) ;
         PutPixel(xf+ix,yf-iy,Color)

      end ;
                                { px = py to asymptote }
      while (-ix < ixx) and (iy < iyx) do begin

         Inc(ie,idex) ;
         Inc(idex,idexx) ;
         Dec(ix) ;
         iey := ie + idey ;
         if abs(ie) > abs(iey) then begin
            ie := iey ;
            Inc(idey,ideyy) ;
            Inc(iy)
         end ;

         PutPixel(xf+ix,yf+iy,Color) ;
         PutPixel(xf+ix,yf-iy,Color)

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
