{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeHyperbola ( xc, yc : integer ; { center }
                              a, b : word ; { radii }
                                ta : single ) ; { rotation angle (rad) }

     { HyprRAM - draw hyperbola using rotation angle       }
     {           method and `minimum' angle step           }

const
   dx = 0.12468 ;
   coshdx = 1.007783 ;
   isinhdx : longint = $0800 ;
   icoshdx : longint = $4080 ;

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   icosta,isinta    : longint ; { rotation angle functions B15 }
   iacosta,iasinta  : longint ; { rotation angle functions - aspect B15 }
   it,ixa,iya       : longint ; { coordinate variables B0 }
   ixb,iyb          : longint ; { coordinate variables B0 }
   xx,yx            : single ;  { coordinate limits }
   r,idx,ndx        : integer ; { loop control }
   ix0,iy0,ix1,iy1  : integer ; { display variables B0 }
   ix2,iy2,ix3,iy3  : integer ; { display variables B0 }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step }
   if a > b then
      r := a
   else
      r := b ;

   if xc > 0 then
      if xc > GetMaxX + 1 then
         xx := xc
      else
         if xc > GetMaxX div 2 then
            xx := xc
         else
            xx := GetMaxX - xc
   else
      xx := abs(xc) + GetMaxX + 1 ;

   if yc > 0 then
      if yc > GetMaxY + 1 then
         yx := yc
      else
         if yc > GetMaxY div 2 then
            yx := yc
         else
            yx := GetMaxY - yc
   else
      yx := abs(yc) + GetMaxY + 1 ;

   ndx := Round(ln(2*sqrt(sqr(xx)+sqr(yx))/r)/ln(coshdx+dx)) ;
                                { rotation angle functions }
   icosta := Round(cos(ta) * 32768) ;
   isinta := Round(sin(ta) * 32768);
   iacosta := RoundScaleB16(iar * icosta) ;
   iasinta := RoundScaleB16(iar * isinta) ;
                                { prescale }
   ixa := SwapLong(longint(a)) ;
   iya := 0 ;
   ixb := SwapLong(longint(b)) ;
   iyb := 0 ;
                                { starting points }
   ix0:= RoundScaleB16(longint(a) * icosta shl 1) ;
   iy0 := -RoundScaleB16(longint(a) * iasinta shl 1)  ;
   ix2 := ix0 ;
   iy2 := iy0 ;
                                { hyperbola }
   for idx := 1 to ndx do begin
                                { step coordinates }
      it := (ixa div 16 + iya) div 8 + ixa ;
      iya := (iya div 16 + ixa) div 8 + iya ;
      ixa := it ;

      it := (ixb div 16 + iyb) div 8 + ixb ;
      iyb := (iyb div 16 + ixb) div 8 + iyb ;
      ixb := it ;
                                { rotate coordinates }
      ix1 := RoundScaleB16((LongHi(ixa) * icosta  +
              LongHi(iyb) * isinta) shl 1) ;
      iy1 := RoundScaleB16((-LongHi(ixa) * iasinta +
              LongHi(iyb) * iacosta) shl 1);
      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;

      ix3 := RoundScaleB16((LongHi(ixa) * icosta -
              LongHi(iyb) * isinta) shl 1) ;
      iy3 := RoundScaleB16((-LongHi(ixa) * iasinta -
              LongHi(iyb) * iacosta) shl 1);
      Line(xc+ix2,yc+iy2,xc+ix3,yc+iy3) ;
      Line(xc-ix2,yc-iy2,xc-ix3,yc-iy3) ;
                                { ladder down }
      ix2 := ix3 ;  iy2 := iy3 ;
      ix0 := ix1 ;  iy0 := iy1

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
