{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeHyperbola ( xc, yc : integer ; { center }
                              a, b : word ; { radii }
                                ta : single ) ; { rotation angle (rad) }

     { HyprRAF - draw hyperbola using rotation angle }
     {           method and fixed point arithmetic   }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B15 }
   icosta,isinta    : longint ; { rotation angle functions B15 }
   iacosta,iasinta  : longint ; { rotation angle functions - aspect B15 }
   dx,coshdx        : single ;  { step and function }
   icoshdx,isinhdx  : longint ; { step functions B16 }
   it,ixa,iya       : longint ; { coordinate variables B0 }
   ixb,iyb          : longint ; { coordinate variables B0 }
   xx,yx            : single ;  { coordinate limits }
   r,idx,ndx        : integer ; { loop control }
   ix0,iy0,ix1,iy1  : integer ; { display variables B0 }
   ix2,iy2,ix3,iy3  : integer ; { display variables B0 }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   iar := longint(ixar) shl 15 div iyar ;
                                { step and functions }
   if a > b then
      r := a
   else
      r := b ;
   dx := 2.0 * sqrt(1.0/r) ;
   coshdx := cosh(dx) ;

   if xc > 0 then
      if xc > GetMaxX + 1 then
         xx := xc
      else
         if xc > GetMaxX div 2 then
            xx := xc
         else
            xx := GetMaxX - xc
   else
      xx := abs(xc) + GetMaxX + 1 ;

   if yc > 0 then
      if yc > GetMaxY + 1 then
         yx := yc
      else
         if yc > GetMaxY div 2 then
            yx := yc
         else
            yx := GetMaxY - yc
   else
      yx := abs(yc) + GetMaxY + 1 ;

   ndx := Round(ln(2*sqrt(sqr(xx)+sqr(yx))/r)/ln(coshdx+dx)) ;

   icoshdx := Round(coshdx * 65536) ;
   isinhdx := Round(sinh(dx) * 65536) ;
                                { rotation angle functions }
   icosta := Round(cos(ta) * 32768) ;
   isinta := Round(sin(ta) * 32768);
   iacosta := RoundScaleB16(iar * icosta shl 1) ;
   iasinta := RoundScaleB16(iar * isinta shl 1) ;
                                { offset }
   ixa := a ;
   iya := 0 ;
   ixb := b ;
   iyb := 0 ;
                                { starting points }
   ix0:= RoundScaleB16(icosta * ixa shl 1) ;
   iy0 := -RoundScaleB16(iasinta * ixa shl 1)  ;
   ix2 := ix0 ;
   iy2 := iy0 ;
                                { hyperbola }
   for idx := 1 to ndx do begin
                                { step coordinates }
      it := RoundScaleB16(ixa * icoshdx + iya * isinhdx) ;
      iya := RoundScaleB16(ixa * isinhdx + iya * icoshdx) ;
      ixa := it ;

      it := RoundScaleB16(ixb * icoshdx + iyb * isinhdx) ;
      iyb := RoundScaleB16(ixb * isinhdx + iyb * icoshdx) ;
      ixb := it ;
                                { rotate coordinates }
      ix1 := RoundScaleB16((icosta * ixa + isinta * iyb) shl 1) ;
      iy1 := RoundScaleB16((-iasinta * ixa + iacosta * iyb) shl 1);
      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;

      ix3 := RoundScaleB16((icosta * ixa - isinta * iyb) shl 1) ;
      iy3 := RoundScaleB16((-iasinta * ixa - iacosta * iyb) shl 1);
      Line(xc+ix2,yc+iy2,xc+ix3,yc+iy3) ;
      Line(xc-ix2,yc-iy2,xc-ix3,yc-iy3) ;
                                { ladder down }
      ix2 := ix3 ;  iy2 := iy3 ;
      ix0 := ix1 ;  iy0 := iy1

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
