{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeHyperbola ( xc, yc : integer ; { center }
                              a, b : word ; { radii }
                                ta : single ) ; { rotation angle (rad) }

     { HyprMB - Modified Bresenham hyperbola algorithm }

var
   Color            : word ;    { default color }
   px,py            : single ;  { aspect variables }
   pxx,pyy          : single ;  {        "         }
   ix,iy            : integer ; { display coordinates }
   ixx,iyx          : integer ; { maximum display coordinates }
   ie,iex,iey       : longint ; { error variables }
   idex,idey        : longint ; { error offset counters }
   idexx,ideyy      : longint ; { error offset increments }

begin

   if (a > 0) and (b > 0) then begin

      Color := GetColor ;
                                { initialize assuming 3/2 aspect }
      px := 3 * GetMaxY ;
      py := 2 * GetMaxX ;
      if px > py then begin
         py := py / px ;
         px := 1.0
      end
      else begin
         px := px / py ;
         py := 1.0
      end ;

      pxx := sqr(b*px) ;
      pyy := -sqr(a*py) ;
                                { error increments }
      idexx := Round(2*pxx) ;
      ideyy := Round(2*pyy) ;
                                { starting point }
      ix := a ;
      iy := 0 ;
      ie := 0 ;
                                { error offsets }
      idex := Round((2*ix+1)*pxx) ;
      idey := Round(pyy) ;
                                { diameter points }
      PutPixel(xc+ix,yc,Color) ;
      PutPixel(xc-ix,yc,Color) ;
                                { coordinate limits }
      if xc > 0 then
         if xc > GetMaxX + 1 then
            ixx := xc
         else
            if xc > GetMaxX div 2 then
               ixx := xc
            else
               ixx := GetMaxX - xc
      else
         ixx := abs(xc) + GetMaxX + 1 ;

      if yc > 0 then
         if yc > GetMaxY + 1 then
            iyx := yc
         else
            if yc > GetMaxY div 2 then
               iyx := yc
            else
               iyx := GetMaxY - yc
      else
         iyx := abs(yc) + GetMaxY + 1 ;
                                { octant points - 1,4,5,8 }
      while (-idey < idex) and (ix < ixx) and (iy < iyx) do begin

         Inc(ie,idey) ;
         Inc(idey,ideyy) ;
         Inc(iy) ;
         iex := ie + idex ;
         if abs(ie) >= abs(iex) then begin
            ie := iex ;
            Inc(idex,idexx) ;
            Inc(ix)
         end ;

         PutPixel(xc+ix,yc+iy,Color) ;
         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color) ;
         PutPixel(xc-ix,yc-iy,Color)

      end ;
                               { octant points - 2,3,6,7 }
      while (ix < ixx) and (iy < iyx) do begin

         Inc(ie,idex) ;
         Inc(idex,idexx) ;
         Inc(ix) ;
         iey := ie + idey ;
         if abs(ie) >= abs(iey) then begin
            ie := iey ;
            Inc(idey,ideyy) ;
            Inc(iy)
         end ;

         PutPixel(xc+ix,yc+iy,Color) ;
         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color) ;
         PutPixel(xc-ix,yc-iy,Color)

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
