{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeHyperbola ( xc, yc : integer ; { center }
                              a, b : word ; { radii }
                                ta : single ) ; { rotation angle (rad) }

     { HyprDAMG - draw hyperbola using difference angle    }
     {            method, `minimum' angle step, and assign }
     {            difference equation generator to each    }
     {            term of rotated coordinates              }

const
   dx = 0.12492 ;
   coshdx = 1.007813 ;
   isinhdx : longint = $2010 ;
   icoshdx : longint = $10200 ;

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B15 }
   xx,yx            : single ;  { coordinate limits }
   r,idx,ndx        : integer ; { loop control }
   ixa0c,ixa1c,ixa2c : longint ; { generator B22 }
   ixa0as,ixa1as,ixa2as : longint ; { generator B22 }
   iyb0s,iyb1s,iyb2s : longint ; { generator B22 }
   iyb0ac,iyb1ac,iyb2ac : longint ; { generator B22 }
   icosta,isinta    : longint ; { rotation B14 }
   iacosta,iasinta  : longint ; { rotation - aspect B14 }
   ix0,iy0,ix1,iy1  : integer ; { display variables B0 }
   ix2,iy2,ix3,iy3  : integer ; { display variables B0 }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step }
   if a > b then
      r := a
   else
      r := b ;

   if xc > 0 then
      if xc > GetMaxX + 1 then
         xx := xc
      else
         if xc > GetMaxX div 2 then
            xx := xc
         else
            xx := GetMaxX - xc
   else
      xx := abs(xc) + GetMaxX + 1 ;

   if yc > 0 then
      if yc > GetMaxY + 1 then
         yx := yc
      else
         if yc > GetMaxY div 2 then
            yx := yc
         else
            yx := GetMaxY - yc
   else
      yx := abs(yc) + GetMaxY + 1 ;

   ndx := Round(ln(2*sqrt(sqr(xx)+sqr(yx))/r)/ln(coshdx+dx)) ;
                                { aspect and rotation }
   icosta := Round(cos(ta) * 32768) ;
   isinta := Round(sin(ta) * 32768) ;
   iacosta := RoundScaleB16(iar * icosta) ;
   iasinta := RoundScaleB16(iar * isinta) ;
                                { offset and initialize }
                                { difference equations  }
   ixa1c := a * icosta shl 1 ;
   ixa2c := RoundScaleB16(a * icoshdx) * icosta shl 1 ;
   ixa1as := a * iasinta shl 1 ;
   ixa2as := RoundScaleB16(a * icoshdx) * iasinta shl 1 ;
   iyb1s := 0 ;
   iyb2s := -RoundScaleB16(b * isinhdx) * isinta shl 1 ;
   iyb1ac := 0 ;
   iyb2ac := -RoundScaleB16(b * isinhdx) * iacosta shl 1 ;
                                { starting points }
   ix0 := RoundScaleB16(ixa1c) ;
   iy0 := -RoundScaleB16(ixa1as) ;
   ix2 := ix0 ;
   iy2 := iy0 ;
                                { hyperbola }
   for idx := 1 to ndx do begin
                                { step coordinates }
      ixa0c := (ixa1c + ixa1c div 128) shl 1 - ixa2c ;
      ixa0as := (ixa1as + ixa1as div 128) shl 1 - ixa2as ;
      iyb0s := (iyb1s + iyb1s div 128) shl 1 - iyb2s ;
      iyb0ac := (iyb1ac + iyb1ac div 128) shl 1 - iyb2ac ;

      ix1 := RoundScaleB16(ixa0c + iyb0s) ;
      iy1 := RoundScaleB16(-ixa0as + iyb0ac) ;

      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;

      ix3 := RoundScaleB16(ixa0c - iyb0s) ;
      iy3 := RoundScaleB16(-ixa0as - iyb0ac) ;

      Line(xc+ix2,yc+iy2,xc+ix3,yc+iy3) ;
      Line(xc-ix2,yc-iy2,xc-ix3,yc-iy3) ;
                                { ladder down }
      ixa2c := ixa1c ;  ixa1c := ixa0c ;
      ixa2as := ixa1as ;  ixa1as := ixa0as ;
      iyb2s := iyb1s ;  iyb1s := iyb0s ;
      iyb2ac := iyb1ac ;  iyb1ac := iyb0ac ;
      ix0 := ix1 ;  iy0 := iy1 ;
      ix2 := ix3 ;  iy2 := iy3

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
