{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeHyperbola ( xc, yc : integer ; { center }
                              a, b : word ; { radii }
                                ta : single ) ; { rotation angle (rad) }

     { HyprDAF - draw hyperbola using difference angle     }
     {           and fixed point arithmetic                }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   dx,coshdx        : single ;  { step and function }
   icoshdx          : longint ; { step function B16 }
   icoshdxt2        : longint ; { difference equation coefficient B16 }
   xx,yx            : single ;  { coordinate limits }
   r,idx,ndx        : integer ; { loop control }
   ixa0,ixa1,ixa2   : longint ; { generator B0 }
   iyb0,iyb1,iyb2   : longint ; { generator B0 }
   icosta,isinta    : longint ; { rotation B15 }
   iacosta,iasinta  : longint ; { rotation - aspect B15 }
   ix0,iy0,ix1,iy1  : integer ; { display variables B0 }
   ix2,iy2,ix3,iy3  : integer ; { display variables B0 }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   iar := longint(ixar) shl 16 div longint(iyar) ;
                                { step angle functions }
   if a > b then
      r := a
   else
      r := b ;
   dx := 2.0 * sqrt(1.0/r) ;
   coshdx := cosh(dx) ;

   if xc > 0 then
      if xc > GetMaxX + 1 then
         xx := xc
      else
         if xc > GetMaxX div 2 then
            xx := xc
         else
            xx := GetMaxX - xc
   else
      xx := abs(xc) + GetMaxX + 1 ;

   if yc > 0 then
      if yc > GetMaxY + 1 then
         yx := yc
      else
         if yc > GetMaxY div 2 then
            yx := yc
         else
            yx := GetMaxY - yc
   else
      yx := abs(yc) + GetMaxY + 1 ;

   ndx := Round(ln(2*sqrt(sqr(xx)+sqr(yx))/r)/ln(coshdx+dx)) ;

   icoshdx := Round(coshdx * 65536) ;
   icoshdxt2 := Round(coshdx * 131072) ;
                                { offset and initialize }
                                { difference equations  }
   ixa1 := a ;
   ixa2 := RoundScaleB16(a * icoshdx);
   iyb1 := 0 ;
   iyb2 := -Round(b * sinh(dx)) ;
                                { aspect and rotation }
   icosta := Round(cos(ta) * 32768) ;
   isinta := Round(sin(ta) * 32768) ;
   iacosta := RoundScaleB16(iar * icosta) ;
   iasinta := RoundScaleB16(iar * isinta) ;
                                { starting points }
   ix0 := RoundScaleB16(ixa1 * icosta shl 1) ;
   iy0 := -RoundScaleB16(ixa1 * iasinta shl 1) ;
   ix2 := ix0 ;
   iy2 := iy0 ;
                                { hyperbola }
   for idx := 1 to ndx do begin
                                { step coordinates }
      ixa0 := RoundScaleB16(icoshdxt2 * ixa1) - ixa2 ;
      iyb0 := RoundScaleB16(icoshdxt2 * iyb1) - iyb2 ;

      ix1 := RoundScaleB16((ixa0 * icosta + iyb0 * isinta) shl 1) ;
      iy1 := RoundScaleB16((-ixa0 * iasinta + iyb0 * iacosta) shl 1) ;

      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;

      ix3 := RoundScaleB16((ixa0 * icosta - iyb0 * isinta) shl 1);
      iy3 := RoundScaleB16((-ixa0 * iasinta - iyb0 * iacosta) shl 1);

      Line(xc+ix2,yc+iy2,xc+ix3,yc+iy3) ;
      Line(xc-ix2,yc-iy2,xc-ix3,yc-iy3) ;
                                { ladder down }
      ixa2 := ixa1 ;  ixa1 := ixa0 ;
      iyb2 := iyb1 ;  iyb1 := iyb0 ;
      ix0 := ix1 ;  iy0 := iy1 ;
      ix2 := ix3 ;  iy2 := iy3

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
