{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipRAM - draw ellipse using rotation angle method  }
     {           and `minimum' angle step                  }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   icosta,isinta    : longint ; { rotation angle functions B16 }
   ira,irb          : longint ; { offset radii B6 }
   ida              : integer ; { loop control }
   it,ixa,iya       : longint ; { coordinate variables B6 }
   ixb,iyb          : longint ; { coordinate variables B6 }
   ix0,iy0          : integer ; { display coordinates B0 }

begin
                                { constraint test }
   if (a < 511) and (b < 511) then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { offset, rotation, prescale, }
                                { aspect and reflection       }
      icosta := Round(cos(ta) * 65536) ;
      isinta := Round(sin(ta) * 65536) ;

      ira := a shl 6 + idr ;
      irb := b shl 6 + idr ;

      ixa := RoundScaleB16(ira * icosta) ;
      iya := -RoundScaleB16(irb * isinta) ;

      ixb := RoundScaleB16(RoundScaleB16(irb * icosta) * iar) ;
      iyb := -RoundScaleB16(RoundScaleB16(ira * isinta) * iar) ;
                                { starting point }
      ix0 := RoundScaleB6(ixa) ;
      iy0 := RoundScaleB6(iyb) ;
      MoveTo(xc+ix0,yc+iy0) ;
                                { ellipse }
      for ida := 1 to 49 do begin
                                { rotate coordinates }
         it := ((ixa shl 3 - iya) shl 4 - ixa) div 128 ;
         iya := ((iya shl 3 + ixa) shl 4 - iya) div 128 ;
         ixa := it ;

         it := ((ixb shl 3 - iyb) shl 4 - ixb) div 128 ;
         iyb := ((iyb shl 3 + ixb) shl 4 - iyb) div 128 ;
         ixb := it ;
                                { draw stroke }
         LineTo(xc+RoundScaleB6(ixa),yc+RoundScaleB6(iyb))

      end ;
                                { closure }
      LineTo(xc+ix0,yc+iy0)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
