{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipRAF - draw ellipse using rotation angle method  }
     {           and fixed point arithmetic                }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   da               : single ;  { step angle }
   icosda,isinda    : longint ; { step angle functions B16 }
   ira,irb          : longint ; { offset radii B6 }
   icosta,isinta    : longint ; { rotation variables B16 }
   it,ixa,iya       : longint ; { coordinate variables B6 }
   ixb,iyb          : longint ; { coordinate variables B6 }
   r,ida,nda        : integer ; { loop control }

begin
                                { constraint test }
   if (a < 511) and (b < 511) then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step angle and functions }
      if a > b then
         r := a
      else
         r := b ;
      da := 2.0 * sqrt(1.0/r) ;
      nda := Round(2.0 * Pi / da) ;
      if Odd(nda) then Inc(nda) ;
      da := 2.0 * Pi / nda ;
      icosda := Round(cos(da) * 65536) ;
      isinda := Round(sin(da) * 65536) ;
                                { offset and scale radii }
      ira := a shl 6 + idr ;
      irb := b shl 6 + idr ;
                                { scale rotation functions }
      icosta := Round(cos(ta) * 65536) ;
      isinta := Round(sin(ta) * 65536) ;
                                { coordinate variables with        }
                                { rotation, aspect, and reflection }
      ixa := RoundScaleB16(ira * icosta) ;
      iya := -RoundScaleB16(irb * isinta) ;
      ixb := RoundScaleB16(RoundScaleB16(irb * icosta) * iar) ;
      iyb := -RoundScaleB16(RoundScaleB16(ira * isinta) * iar) ;
                                { starting point }
      MoveTo(xc+RoundScaleB6(ixa),yc+RoundScaleB6(iyb)) ;
                                { ellipse }
      for ida := 1 to nda do begin
                                { rotate coordinates }
         it := RoundScaleB16(ixa * icosda - iya * isinda) ;
         iya := RoundScaleB16(ixa * isinda + iya * icosda) ;
         ixa := it ;

         it := RoundScaleB16(ixb * icosda - iyb * isinda) ;
         iyb := RoundScaleB16(ixb * isinda + iyb * icosda) ;
         ixb := it ;
                                { draw chord }
         LineTo(xc+RoundScaleB6(ixa),yc+RoundScaleB6(iyb))

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
