{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipRA2 - draw ellipse using rotation angle method  }
     {           and semi-circular symmetry                }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   ar               : single ;  { aspect ratio }
   da,cosda,sinda   : single ;  { step angle and functions }
   t,xa,ya,xb,yb    : single ;  { coordinate variables }
   r,ida,ndad2      : integer ; { loop control }
   ix0,iy0,ix1,iy1  : integer ; { display variables }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   ar := ixar/iyar ;
                                { step angle and functions }
   if a > b then
      r := a
   else
      r := b ;
   da := 2.0 * sqrt(1.0/r) ;
   ndad2 := Round(Pi / da) ;
   da := Pi / ndad2 ;
   cosda := cos(da) ;
   sinda := sin(da) ;
                                { coordinate variables with }
                                { rotation, offset, aspect, }
                                { and reflection            }
   xa := (a+dr) * cos(ta) ;
   ya := -(b+dr) * sin(ta) ;
   xb := (b+dr) * cos(ta) * ar ;
   yb := -(a+dr) * sin(ta) * ar ;
                                { starting point }
   ix0 := Round(xa) ;
   iy0 := Round(yb) ;
                                { ellipse }
   for ida := 1 to ndad2 do begin
                                { rotate coordinates }
      t := xa * cosda - ya * sinda ;
      ya := xa * sinda + ya * cosda ;
      xa := t ;

      t := xb * cosda - yb * sinda ;
      yb := xb * sinda + yb * cosda ;
      xb := t ;
                                { semi-circular symmetry }
      ix1 := Round(xa) ;
      iy1 := Round(yb) ;
      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;
                                { ladder down }
      ix0 := ix1 ;  iy0 := iy1

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
