{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipMBR - Modified Bresenham ellipse algorithm with }
     {           rotation and aspect correction            }

var
   Color            : word ;    { default color }
   a2,b2            : single ;  { starting point parameters }
   costa,sinta      : single ;  { rotation angle functions }
   costa2,sinta2    : single ;  {            "             }
   px,py            : single ;  { aspect variables }
   pxx,pxy,pyy      : single ;  {        "         }
   x0,y0            : single ;  { starting point, float }
   ix0,iy0          : integer ; {        "      , fixed }
   ix,iy            : integer ; { coordinates variables }
   ie,iex,iey       : longint ; { error variables }
   idex,idey        : longint ; { error offsets }
   idex0,idey0      : longint ; {       "      , initial }
   idexx,idexy      : longint ; { error increments }
   ideyx,ideyy      : longint ; {        "         }

begin

   if (a > 0) and (b > 0) then begin

      Color := GetColor ;

      a2 := sqr(a) ;
      b2 := sqr(b) ;
                                { rotation angle functions }
      costa := cos(ta) ;
      costa2 := sqr(costa) ;
      sinta := sin(ta) ;
      sinta2 := sqr(sinta) ;
                                { initialize assuming 3/2 aspect }
      px := 3 * GetMaxY ;
      py := 2 * GetMaxX ;
                               { scaling parameters }
      if px > py then begin
         py := py / px ;
         px := 1.0
      end
      else begin
         px := px / py ;
         py := 1.0
      end ;
                                { find negative y extremum point }
      pxx := sqr(px) * (b2 * costa2 + a2 * sinta2) ;
      pxy := px * py * (b2 - a2) * sinta * costa ;
      pyy := sqr(py) * (b2 * sinta2 + a2 * costa2) ;

      idexx := Round(2.0*pxx) ;
      idexy := Round(2.0*pxy) ;
      ideyx := idexy ;
      ideyy := Round(2.0*pyy) ;
                                { initial coordinates }
      y0 := sqrt(pxx)/py ;
      iy0 := Round(y0) ;
      x0 := -y0 * pxy / pxx ;
      ix0 := Round(x0) ;

      idex0 := Round((2.0*x0+1.0) * pxx + 2.0*y0 * pxy) ;
      idey0 := Round(2.0*x0 * pxy + (2.0*y0+1.0) * pyy) ;
                                { starting point }
      ix := ix0 ;
      iy := iy0 ;
      ie := 0 ;
                                { extremum diagonal points }
      PutPixel(xc+ix,yc-iy,Color) ;
      PutPixel(xc-ix,yc+iy,Color) ;
                               { clockwise }
      idex := idex0 ;
      idey := -idey0 + ideyy ;

      while idex < -idey do begin

         Inc(ie,idex) ;
         Inc(idex,idexx) ;
         Inc(ix) ;
         Dec(idey,ideyx) ;
         iey := ie + idey ;
         if abs(ie) >= abs(iey) then begin
            ie := iey ;
            Dec(idex,idexy) ;
            Dec(iy) ;
            Inc(idey,ideyy) ;
         end ;

         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color)

      end ;

      while -idey > 0 do begin

         Inc(ie,idey) ;
         Inc(idey,ideyy) ;
         Dec(iy) ;
         Dec(idex,idexy) ;
         iex := ie + idex ;
         if abs(ie) >= abs(iex) then begin
            ie := iex ;
            Dec(idey,ideyx) ;
            Inc(ix) ;
            Inc(idex,idexx)
         end ;

         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color)

      end ;
                               { counter clockwise }
      ix := ix0 ;
      iy := iy0 ;
      ie := 0 ;

      idex := -idex0 + idexx ;
      idey := -idey0 + ideyy ;

      while idex < -idey do begin

         Inc(ie,idex) ;
         Inc(idex,idexx) ;
         Dec(ix) ;
         Inc(idey,ideyx) ;
         iey := ie + idey ;
         if abs(ie) >= abs(iey) then begin
            ie := iey ;
            Inc(idey,ideyy) ;
            Dec(iy) ;
            Inc(idex,idexy)
         end ;

         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color)

      end ;

      while -idey > 0 do begin

         Inc(ie,idey) ;
         Inc(idey,ideyy) ;
         Dec(iy) ;
         Inc(idex,idexy) ;
         iex := ie + idex ;
         if abs(ie) >= abs(iex) then begin
            ie := iex ;
            Inc(idex,idexx) ;
            Dec(ix) ;
            Inc(idey,ideyx)
         end ;

         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color)

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
