{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipRAF - draw ellipse using difference angle       }
     {           method and fixed point arithmetic         }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   r                : word ;    { effective radius }
   da,cosda         : single ;  { step angle }
   icosda,isinda    : longint ; { step angle functions B16 }
   ida,nda          : integer ; { loop control }
   icosdat2         : longint ; { difference equation coefficient B16 }
   ira,irb          : longint ; { offset radii B6 }
   ixa0,ixa1,ixa2   : longint ; { cosine generator variables B5 }
   iyb0,iyb1,iyb2   : longint ; { sine generator variables B5 }
   icosta,isinta    : longint ; { rotation parameters B11 }
   iacosta,iasinta  : longint ; { rotation parameters B11 }
   ix0,iy0,ix1,iy1  : integer ; { display variables B0 }

begin
                                { constraint test }
   if (a < 510) and (b < 510) then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step angle functions }
      if a > b then
         r := a
      else
         r := b ;
      da := 2.0 * sqrt(1.0/r) ;
      nda := Round(2.0 * Pi / da) ;
      if Odd(nda) then Inc(nda) ;
      da := 2.0 * Pi / nda ;
      cosda := cos(da) ;
      icosda := Round(cosda * 65536) ;
      isinda := Round(sin(da) * 65536) ;
      icosdat2 := Round(cosda * 131072) ;
                                { offset, prescale, reflect }
      ira := a shl 5 + idr div 2 ;
      ixa1 := ira ;
      ixa2 := RoundScaleB16(ira * icosda) ;
      irb := b shl 5 + idr div 2 ;
      iyb1 := 0 ;
      iyb2 := -RoundScaleB16(irb * isinda) ;
                                { aspect and rotation }
      icosta := Round(cos(ta) * 2048) ;
      isinta := Round(sin(ta) * 2048) ;
      iacosta := RoundScaleB16(iar * icosta) ;
      iasinta := RoundScaleB16(iar * isinta) ;
                                { starting point }
      ix0 := RoundScaleB16(ixa1 * icosta) ;
      iy0 := -RoundScaleB16(ixa1 * iasinta) ;
      MoveTo(xc+ix0,yc+iy0) ;
                                { ellipse }
      for ida := 1 to nda-1 do begin
                                { step coordinates }
         ixa0 := RoundScaleB16(icosdat2 * ixa1) - ixa2 ;
         iyb0 := RoundScaleB16(icosdat2 * iyb1) - iyb2 ;
                                { rotate }
         ix1 := RoundScaleB16(ixa0 * icosta + iyb0 * isinta) ;
         iy1 := RoundScaleB16(-ixa0 * iasinta + iyb0 * iacosta) ;
                                { draw stroke }
         LineTo(xc+ix1,yc+iy1) ;
                                { ladder down }
         ixa2 := ixa1 ;  ixa1 := ixa0 ;
         iyb2 := iyb1 ;  iyb1 := iyb0

      end ;
                                { closure }
      LineTo(xc+ix0,yc+iy0)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
