{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program StrokeHyperbolaDemo ;

     {    DemoHypr - draw hyperbola with given radii and   }
     {               specified rotation angle              }

uses GRAPH ;

{~~~~~~~~~~~~~~~~~~ hyperbola routines ~~~~~~~~~~~~~~~~~~~~}

{$I conic.pas }

{-$I hyprda.pas }
{-$I hyprdaf.pas }
{-$I hyprdam.pas }
{-$I hyprdamg.pas }
{-$I hyprmb.pas }
{-$I hyprmbr.pas }
{-$I hyprra.pas }
{$I hyprraf.pas }
{-$I hyprram.pas }

{~~~~~~~~~~~~~~~~~~~~~ main program ~~~~~~~~~~~~~~~~~~~~~~~}

var
   grDriver, grMode : integer ; { graph control parameters }
   a, b           : word ;    { hyperbola radii }
   xc, yc           : integer ; { hyperbola center }
   ta, tad          : single ;  { rotation angle }

begin
                                { prompt for radii }
   repeat
      write ('Radii: ') ;
      readln (a,b)
   until (a > 0) and (b > 0) ;
                                { prompt for rotation angle }
   repeat
      write ('Rotation angle (deg): ') ;
      readln (tad)
   until (tad >= 0.0) and (tad < 360.0) ;
   ta := tad / 180.0 * Pi ;
                                { initiate graphics }
   grDriver := Detect ;
   InitGraph(grDriver,grMode,'') ;
                                { center of display }
   xc := (GetMaxX + 1) div 2 ;
   yc := (GetMaxY + 1) div 2 ;
                                { draw hyperbola }
   StrokeHyperbola(xc,yc,a,b,ta) ;
                                { pause }
   readln ;
   CloseGraph

end.

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
