{ Copyright (C) 1988 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program RotateHyperbolicAngle (output) ;

     { DelHAngD - Compute exact and approximate number of  }
     {    iterations required to drive hyperbolic cosine   }
     {    coordinate to display limit.                     }

uses GRAPH ;

var
     grDriver,grMode : integer ; { graphics mode parameters }
     xc             : integer ; { x coordinate center }
     isr,r          : integer ; { shift parameter and radius }
     dx,coshdx,sinhdx : single ; { step angle and functions }
     coshx,sinhx    : single ;  { coordinate angle functions }
     ndx,ndxe       : integer ; { number of coordinate rotations }

begin
                                { initialize graphics }
   grDriver := Detect ;
   InitGraph(grDriver,grMode,'') ;
   CloseGraph ;
                                { for radii from 1 to 1024 }
   write (output,'X Center: ') ;
   readln (xc) ;

   for isr := 0 to 10 do begin
      r := 1 shl isr ;
      dx := 2.0*sqrt(1.0/r) ;
      coshdx := (exp(dx) + exp(-dx))/2.0 ;
      sinhdx := sqrt(sqr(coshdx) - 1.0) ;
      coshx := 1.0 ;
      sinhx := 0.0 ;
      ndx := 0 ;
                                { compute ndx }
      while (r * coshx) <= (abs(xc) + GetMaxX) do begin
         coshx := coshx * coshdx + sinhx * sinhdx ;
         sinhx := sqrt(sqr(coshx) - 1.0) ;
         Inc(ndx)
      end ;
                                { estimate ndx }
      ndxe := Trunc(ln(2*(abs(xc)+GetMaxX)/r)/ln(coshdx+dx)) ;
      writeln (output,' ',r:5,' ',dx:10:5,' ',ndx:4,' ',ndxe:4)

   end
end.

{ Copyright (C) 1988 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
