{ Copyright (C) 1988 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program DeltaCircularAngle (output) ;

     { DelCAng - Compute number of chord segments required }
     {           by chord-tangent difference equal to one. }

var
   r,irs : integer ;
   da,dad,dade,dada : single ;
   cosdad2,sindad2 : single ;
   nda,ndae : integer ;

begin
                                { for radii 1-512 }
   for irs := 0 to 10 do begin
      r := 1 shl irs ;
                                { exact increment angle }
      cosdad2 := (r-0.5)/r ;
      sindad2 := sqrt(1.0-sqr(cosdad2)) ;
      if cosdad2 > 0.0 then
         da := 2.0*arctan(sindad2/cosdad2)
      else
         da := Pi / 2.0 ;
      dad := da / Pi * 180 ;
      nda := round(2.0*Pi/da) ;
                                { approximate increment angle }
      da := 2.0*sqrt(1.0/r) ;
      dade := da / Pi * 180 ;
      ndae := round(2.0*Pi/da) ;
                                { adjusted increment angle }
      dada := 360.0/ndae ;
      writeln (output,r:5,' ',dad:10:5,' ',nda:5,
                           ' ',dade:10:5,' ',ndae:5,
                           ' ',dada:10:5)
   end
end.

{ Copyright (C) 1988 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
