{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircRAI2 - draw circle using rotation angle method, }
     {            `increment' angle step, and semi-        }
     {            circular symmetry                        }

var
   ixar,iyar        : word ;    { aspect ratio variables }
   iar              : longint ; { aspect ratio B16 }
   ida              : integer ; { loop control }
   it,ix,iy         : longint ; { coordinate variables B6 }
   ix0,iy0,ix1,iy1  : integer ; { display coordinates B0 }

begin
                                { constraint test }
   if r < 511 then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { prescale and offset }
      ix := r shl 6 + idr ;
      iy := 0 ;
                                { starting point }
      ix0 := RoundScaleB6(ix) ;
      iy0 := iy ;
                                { circle }
      for ida := 1 to 50 do begin
                                { rotate coordinates }
         it := RoundScaleB16(((((ix shl 4 - iy) shl 5 -
               ix) shl 3 - iy) shl 2 - iy) shl 2) ;
         iy := RoundScaleB16(((((iy shl 4 + ix) shl 5 -
               iy) shl 3 + ix) shl 2 + ix) shl 2) ;
         ix := it ;
                                { apply aspect and scale B0 }
         ix1 := RoundScaleB6(ix) ;
         iy1 := RoundScaleB6(LongHi(iy * iar)) ;
                                { semi-circular symmetry }
         Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
         Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;
                                { ladder down }
         ix0 := ix1 ;  iy0 := iy1

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
