{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircDAM2 - draw circle using difference angle       }
     {            method, semi-circular symmetry, and      }
     {            `minimum' angle step                     }

const
   isinda : longint = $0B53 ;
   icosda : longint = $7F80 ;

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   ida              : integer ; { loop control }
   ir               : longint ; { offset radius B14 }
   ixa0,ixa1,ixa2   : longint ; { coordinate variables B14 }
   iya0,iya1,iya2   : longint ; { coordinate variables B14 }
   ix0,iy0,ix1,iy1,ix2,iy2 : integer ; { display variables }

begin
                                { constraint test }
   if r < 511 then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { initialize differences and offset }
      ir := r shl 6 + idr ;
      ixa2 := ir * icosda shl 1 ;
      ixa1 := SwapLong(ir) ;
      iya2 := -RoundScaleB16(ir * isinda shl 1) * iar ;
      iya1 := 0 ;

      ix0 := RoundScaleB6(ir) ;
      iy0 := 0 ;
      ix2 := ix0 ;
      iy2 := iy0 ;
                                { circle }
      for ida := 1 to 35 do begin
                                { step coordinates }
         ixa0 := (ixa1 - ixa1 div 256) shl 1 - ixa2 ;
         iya0 := (iya1 - iya1 div 256) shl 1 - iya2 ;
                                { draw chord }
         ix1 := RoundScaleB6(LongHi(ixa0)) ;
         iy1 := RoundScaleB6(LongHi(iya0)) ;
                                { semi-circular symmetry }
         Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
         Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;
                                { ladder down }
         ixa2 := ixa1 ;  ixa1 := ixa0 ;
         iya2 := iya1 ;  iya1 := iya0 ;
         ix0 := ix1 ;  iy0 := iy1

      end ;
                                { closure }
      Line(xc+ix1,yc+iy1,xc-ix2,yc-iy2) ;
      Line(xc-ix1,yc-iy1,xc+ix2,yc+iy2)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
