{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program BenchHyperbola (output) ;

     { BnchHypr - compute average timing performance of    }
     {            stroke hyperbola routines                }

uses GRAPH, DOS ;

{~~~~~~~~~~~~~~~~~~ hyperbola routines ~~~~~~~~~~~~~~~~~~~~}

{$I conic.pas }

{-$I hyprda.pas }
{-$I hyprdaf.pas }
{-$I hyprdam.pas }
{$I hyprdamg.pas }
{-$I hyprmb.pas }
{-$I hyprmbr.pas }
{-$I hyprra.pas }
{-$I hyprraf.pas }
{-$I hyprram.pas }

{~~~~~~~~~~~~~~~~~~~~~ main program ~~~~~~~~~~~~~~~~~~~~~~~}

const
   nHyperbola = 100 ;

var
   i : integer ;
   xc,yc : integer ;
   Hour,Min,Sec,CentiSec : array[0..2] of word ;
   Time : array[0..2] of single ;
   dTimeHyperbola,dTimeStroke : single ;
   grDetect,grMode : integer ;

begin
   grDetect := Detect ;
   InitGraph(grDetect,grMode,'') ;
   xc := (GetMaxX + 1) shr 1 ;
   yc := (GetMaxY + 1) shr 1 ;
   Randomize ;
   GetTime(Hour[0],Min[0],Sec[0],CentiSec[0]) ;
                                { TURBO BGI ? }
{
   ClearDevice ;
   for i := 1 to nHyperbola do
      Hyperbola(xc,yc,0,360,Random(xc),Random(yc)) ;
}
   GetTime(Hour[1],Min[1],Sec[1],CentiSec[1]) ;
                                { stroke hyperbola }
   ClearDevice ;
   for i := 1 to nHyperbola do
      StrokeHyperbola(Random(GetMaxX),Random(GetMaxY),
                        Random(xc),Random(yc),Pi*Random) ;
   GetTime(Hour[2],Min[2],Sec[2],CentiSec[2]) ;
   CloseGraph ;
                                { convert times to seconds }
   for i := 0 to 2 do
      Time[i] := (Hour[i] * 60.0 + Min[i]) * 60.0 +
                     Sec[i] + CentiSec[i]/100.0 ;
                                { compute average drawing times }
   dTimeHyperbola := (Time[1] - Time[0])/nHyperbola ;
   dTimeStroke := (Time[2] - Time[1])/nHyperbola ;

   writeln (output,'Hyperbola: ',dTimeHyperbola:8:5,'   ',
                   'Stroke: ',dTimeStroke:8:5)

end.

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
