{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program BenchCircle (output) ;

     { BnchCirc - compare average times required by stroke }
     {            circle and BGI circle routines           }

uses GRAPH, DOS ;

{~~~~~~~~~~~~~~~~~~~~~ circle routines ~~~~~~~~~~~~~~~~~~~~}

{$I conic.pas }

{-$I circda2.pas  }
{-$I circdaf.pas }
{-$I circdai.pas }
{-$I circdai2.pas }
{-$I circdam2.pas }
{-$I circdas.pas }
{-$I circmb.pas }
{$I circra.pas }
{-$I circraf4.pas }
{-$I circrai2.pas }
{-$I circrair.pas }
{-$I circram.pas }
{-$I circras.pas }

{~~~~~~~~~~~~~~~~~~~~~ main program ~~~~~~~~~~~~~~~~~~~~~~~}

const
   nCircle = 100 ;

var
   i : integer ;
   xc,yc : integer ;
   Hour,Min,Sec,CentiSec : array[0..2] of word ;
   Time : array[0..2] of single ;
   dTimeCircle,dTimeStroke : single ;
   grDetect,grMode : integer ;

begin
   grDetect := Detect ;
   InitGraph(grDetect,grMode,'') ;
   xc := (GetMaxX + 1) shr 1 ;
   yc := (GetMaxY + 1) shr 1 ;
   Randomize ;
   GetTime(Hour[0],Min[0],Sec[0],CentiSec[0]) ;
                                { TURBO Bresenham }
   ClearDevice ;
   for i := 1 to nCircle do
      Circle(Random(GetMaxX),Random(GetMaxY),Random(xc)) ;
   GetTime(Hour[1],Min[1],Sec[1],CentiSec[1]) ;
                                { stroke circle }
   ClearDevice ;
   for i := 1 to nCircle do
      StrokeCircle(Random(GetMaxX),Random(GetMaxY),Random(xc)) ;
   GetTime(Hour[2],Min[2],Sec[2],CentiSec[2]) ;
   CloseGraph ;
                                { convert times to seconds }
   for i := 0 to 3 do
      Time[i] := (Hour[i] * 60.0 + Min[i]) * 60.0 +
                     Sec[i] + CentiSec[i]/100.0 ;
                                { compute average drawing times }
    dTimeCircle := (Time[1] - Time[0])/nCircle ;
    dTimeStroke := (Time[2] - Time[1])/nCircle ;

   writeln (output,'Circle: ',dTimeCircle:8:5,'   ',
                   'Stroke: ',dTimeStroke:8:5)

end.

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
