{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokePolygon ( xc, yc : integer ; { center }
                            r, n : word ; { radius and number of sides }
                              ta : single ) ; { rotation angle (rad) }

     { PolyDAF - draw regular polygon using difference     }
     {           angle method and fixed point artihmetic   }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   da               : single ;  { step angle }
   icosdat2         : longint ; { difference equation coefficient B15 }
   i                : integer ; { loop control }
   ir               : longint ; { radius B6 }
   ixa0,ixa1,ixa2   : longint ; { coordinate variables B6 }
   iya0,iya1,iya2   : longint ; { coordinate variables B6 }
   ix0,iy0          : integer ; { display variables B6 }

begin
                                { constraint test }
   if (r > 0) and (r < 511) and (n > 2) then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step angle and functions }
      da := 2.0 * Pi / n ;
      icosdat2 := Round(cos(da) * 65536) ;
                                { initialize difference equations }

      ir := r shl 6 ;
      ixa1 := Round(ir * cos(ta)) ;
      ixa2 := Round(ir * cos(ta-da)) ;
      iya1 := RoundScaleB16(Round(ir * sin(ta)) * iar) ;
      iya2 := RoundScaleB16(Round(ir * sin(ta-da)) * iar) ;
                                { starting point with offset }
      ix0 := RoundScaleB6(ixa1) ;
      iy0 := RoundScaleB6(iya1) ;
      MoveTo(xc+ix0,yc+iy0) ;
                                { polygon }
      for i := 1 to n-1 do begin
                                { rotate coordinates }
         ixa0 := RoundScaleB16(icosdat2 * ixa1) shl 1 - ixa2 ;
         iya0 := RoundScaleB16(icosdat2 * iya1) shl 1 - iya2 ;
                                { draw chord }
         LineTo(xc+RoundScaleB6(ixa0),yc+RoundScaleB6(iya0)) ;
                                { ladder down }
         ixa2 := ixa1 ;  ixa1 := ixa0 ;
         iya2 := iya1 ;  iya1 := iya0

      end ;
                                { closure }
      LineTo(xc+ix0,yc+iy0)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
