{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokePolygon ( xc, yc : integer ; { center }
                            r, n : word ; { radius and number of sides }
                              ta : single ) ; { rotation angle (rad) }

     { PolyDA - draw regular polygon using difference      }
     {          angle method and floating point arithmetic }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   ar               : single ;  { aspect ratio }
   da,cosda,sinda   : single ;  { step angle and functions }
   cosdat2          : single ;  { difference equation coefficient }
   costa,sinta      : single ;  { rotation angle functions }
   i                : integer ; { loop control }
   x0,x1,x2         : single ;  { coordinate variables }
   y0,y1,y2         : single ;  { coordinate variables }
   ix0,iy0          : integer ; { display variables }

begin
                                { constraint test }
   if (r > 0) and (n > 2) then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      ar := ixar/iyar ;
                                { step angle and functions }
      da := 2.0 * Pi / n ;
      cosda := cos(da) ;
      sinda := sin(da) ;
      cosdat2 := 2.0 * cosda ;
                                { initialize difference equations }
      costa := cos(ta) ;
      sinta := sin(ta) ;

      x1 := r * costa ;
      x2 := r * (costa * cosda + sinta * sinda) ;
      y1 := r * sinta * ar ;
      y2 := r * (sinta * cosda - costa * sinda) * ar ;
                                { starting point with offset }
      ix0 := Round(x1) ;
      iy0 := Round(y1) ;
      MoveTo(xc+ix0,yc+iy0) ;
                                { polygon }
      for i := 1 to n-1 do begin
                                { rotate coordinates }
         x0 := cosdat2 * x1 - x2 ;
         y0 := cosdat2 * y1 - y2 ;
                                { apply aspect ratio }
         LineTo(xc+Round(x0),yc+Round(y0)) ;
                                { ladder down }
         x2 := x1 ;  x1 := x0 ;
         y2 := y1 ;  y1 := y0

      end ;
                                { closure }
      LineTo(xc+ix0,yc+iy0)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
